// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sesv2.model



/**
 * Enable or disable the Deliverability dashboard. When you enable the Deliverability dashboard, you gain access to reputation, deliverability, and other metrics for the domains that you use to send email using Amazon SES API v2. You also gain the ability to perform predictive inbox placement tests.
 *
 * When you use the Deliverability dashboard, you pay a monthly subscription charge, in addition to any other fees that you accrue by using Amazon SES and other Amazon Web Services services. For more information about the features and cost of a Deliverability dashboard subscription, see [Amazon Pinpoint Pricing](http://aws.amazon.com/pinpoint/pricing/).
 */
public class PutDeliverabilityDashboardOptionRequest private constructor(builder: Builder) {
    /**
     * Specifies whether to enable the Deliverability dashboard. To enable the dashboard, set this value to `true`.
     */
    public val dashboardEnabled: kotlin.Boolean = builder.dashboardEnabled
    /**
     * An array of objects, one for each verified domain that you use to send email and enabled the Deliverability dashboard for.
     */
    public val subscribedDomains: List<DomainDeliverabilityTrackingOption>? = builder.subscribedDomains

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sesv2.model.PutDeliverabilityDashboardOptionRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PutDeliverabilityDashboardOptionRequest(")
        append("dashboardEnabled=$dashboardEnabled,")
        append("subscribedDomains=$subscribedDomains")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dashboardEnabled.hashCode()
        result = 31 * result + (subscribedDomains?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PutDeliverabilityDashboardOptionRequest

        if (dashboardEnabled != other.dashboardEnabled) return false
        if (subscribedDomains != other.subscribedDomains) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sesv2.model.PutDeliverabilityDashboardOptionRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies whether to enable the Deliverability dashboard. To enable the dashboard, set this value to `true`.
         */
        public var dashboardEnabled: kotlin.Boolean = false
        /**
         * An array of objects, one for each verified domain that you use to send email and enabled the Deliverability dashboard for.
         */
        public var subscribedDomains: List<DomainDeliverabilityTrackingOption>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sesv2.model.PutDeliverabilityDashboardOptionRequest) : this() {
            this.dashboardEnabled = x.dashboardEnabled
            this.subscribedDomains = x.subscribedDomains
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sesv2.model.PutDeliverabilityDashboardOptionRequest = PutDeliverabilityDashboardOptionRequest(this)
    }
}
