// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sesv2.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * An object that contains information about the Deliverability dashboard subscription for a verified domain that you use to send email and currently has an active Deliverability dashboard subscription. If a Deliverability dashboard subscription is active for a domain, you gain access to reputation, inbox placement, and other metrics for the domain.
 */
public class DomainDeliverabilityTrackingOption private constructor(builder: Builder) {
    /**
     * A verified domain that’s associated with your Amazon Web Services account and currently has an active Deliverability dashboard subscription.
     */
    public val domain: kotlin.String? = builder.domain
    /**
     * An object that contains information about the inbox placement data settings for the domain.
     */
    public val inboxPlacementTrackingOption: aws.sdk.kotlin.services.sesv2.model.InboxPlacementTrackingOption? = builder.inboxPlacementTrackingOption
    /**
     * The date when you enabled the Deliverability dashboard for the domain.
     */
    public val subscriptionStartDate: aws.smithy.kotlin.runtime.time.Instant? = builder.subscriptionStartDate

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sesv2.model.DomainDeliverabilityTrackingOption = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DomainDeliverabilityTrackingOption(")
        append("domain=$domain,")
        append("inboxPlacementTrackingOption=$inboxPlacementTrackingOption,")
        append("subscriptionStartDate=$subscriptionStartDate")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = domain?.hashCode() ?: 0
        result = 31 * result + (inboxPlacementTrackingOption?.hashCode() ?: 0)
        result = 31 * result + (subscriptionStartDate?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DomainDeliverabilityTrackingOption

        if (domain != other.domain) return false
        if (inboxPlacementTrackingOption != other.inboxPlacementTrackingOption) return false
        if (subscriptionStartDate != other.subscriptionStartDate) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sesv2.model.DomainDeliverabilityTrackingOption = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A verified domain that’s associated with your Amazon Web Services account and currently has an active Deliverability dashboard subscription.
         */
        public var domain: kotlin.String? = null
        /**
         * An object that contains information about the inbox placement data settings for the domain.
         */
        public var inboxPlacementTrackingOption: aws.sdk.kotlin.services.sesv2.model.InboxPlacementTrackingOption? = null
        /**
         * The date when you enabled the Deliverability dashboard for the domain.
         */
        public var subscriptionStartDate: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sesv2.model.DomainDeliverabilityTrackingOption) : this() {
            this.domain = x.domain
            this.inboxPlacementTrackingOption = x.inboxPlacementTrackingOption
            this.subscriptionStartDate = x.subscriptionStartDate
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sesv2.model.DomainDeliverabilityTrackingOption = DomainDeliverabilityTrackingOption(this)

        /**
         * construct an [aws.sdk.kotlin.services.sesv2.model.InboxPlacementTrackingOption] inside the given [block]
         */
        public fun inboxPlacementTrackingOption(block: aws.sdk.kotlin.services.sesv2.model.InboxPlacementTrackingOption.Builder.() -> kotlin.Unit) {
            this.inboxPlacementTrackingOption = aws.sdk.kotlin.services.sesv2.model.InboxPlacementTrackingOption.invoke(block)
        }
    }
}
