// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sesv2.model



/**
 * Represents a request to send a single formatted email using Amazon SES. For more information, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-email-formatted.html).
 */
public class SendEmailRequest private constructor(builder: Builder) {
    /**
     * The name of the configuration set to use when sending the email.
     */
    public val configurationSetName: kotlin.String? = builder.configurationSetName
    /**
     * An object that contains the body of the message. You can send either a Simple message Raw message or a template Message.
     */
    public val content: aws.sdk.kotlin.services.sesv2.model.EmailContent? = builder.content
    /**
     * An object that contains the recipients of the email message.
     */
    public val destination: aws.sdk.kotlin.services.sesv2.model.Destination? = builder.destination
    /**
     * A list of tags, in the form of name/value pairs, to apply to an email that you send using the `SendEmail` operation. Tags correspond to characteristics of the email that you define, so that you can publish email sending events.
     */
    public val emailTags: List<MessageTag>? = builder.emailTags
    /**
     * The address that you want bounce and complaint notifications to be sent to.
     */
    public val feedbackForwardingEmailAddress: kotlin.String? = builder.feedbackForwardingEmailAddress
    /**
     * This parameter is used only for sending authorization. It is the ARN of the identity that is associated with the sending authorization policy that permits you to use the email address specified in the `FeedbackForwardingEmailAddress` parameter.
     *
     * For example, if the owner of example.com (which has ARN arn:aws:ses:us-east-1:123456789012:identity/example.com) attaches a policy to it that authorizes you to use feedback@example.com, then you would specify the `FeedbackForwardingEmailAddressIdentityArn` to be arn:aws:ses:us-east-1:123456789012:identity/example.com, and the `FeedbackForwardingEmailAddress` to be feedback@example.com.
     *
     * For more information about sending authorization, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html).
     */
    public val feedbackForwardingEmailAddressIdentityArn: kotlin.String? = builder.feedbackForwardingEmailAddressIdentityArn
    /**
     * The email address to use as the "From" address for the email. The address that you specify has to be verified.
     */
    public val fromEmailAddress: kotlin.String? = builder.fromEmailAddress
    /**
     * This parameter is used only for sending authorization. It is the ARN of the identity that is associated with the sending authorization policy that permits you to use the email address specified in the `FromEmailAddress` parameter.
     *
     * For example, if the owner of example.com (which has ARN arn:aws:ses:us-east-1:123456789012:identity/example.com) attaches a policy to it that authorizes you to use sender@example.com, then you would specify the `FromEmailAddressIdentityArn` to be arn:aws:ses:us-east-1:123456789012:identity/example.com, and the `FromEmailAddress` to be sender@example.com.
     *
     * For more information about sending authorization, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html).
     *
     * For Raw emails, the `FromEmailAddressIdentityArn` value overrides the X-SES-SOURCE-ARN and X-SES-FROM-ARN headers specified in raw email message content.
     */
    public val fromEmailAddressIdentityArn: kotlin.String? = builder.fromEmailAddressIdentityArn
    /**
     * An object used to specify a list or topic to which an email belongs, which will be used when a contact chooses to unsubscribe.
     */
    public val listManagementOptions: aws.sdk.kotlin.services.sesv2.model.ListManagementOptions? = builder.listManagementOptions
    /**
     * The "Reply-to" email addresses for the message. When the recipient replies to the message, each Reply-to address receives the reply.
     */
    public val replyToAddresses: List<String>? = builder.replyToAddresses

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sesv2.model.SendEmailRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SendEmailRequest(")
        append("configurationSetName=$configurationSetName,")
        append("content=$content,")
        append("destination=$destination,")
        append("emailTags=$emailTags,")
        append("feedbackForwardingEmailAddress=$feedbackForwardingEmailAddress,")
        append("feedbackForwardingEmailAddressIdentityArn=$feedbackForwardingEmailAddressIdentityArn,")
        append("fromEmailAddress=$fromEmailAddress,")
        append("fromEmailAddressIdentityArn=$fromEmailAddressIdentityArn,")
        append("listManagementOptions=$listManagementOptions,")
        append("replyToAddresses=$replyToAddresses")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = configurationSetName?.hashCode() ?: 0
        result = 31 * result + (content?.hashCode() ?: 0)
        result = 31 * result + (destination?.hashCode() ?: 0)
        result = 31 * result + (emailTags?.hashCode() ?: 0)
        result = 31 * result + (feedbackForwardingEmailAddress?.hashCode() ?: 0)
        result = 31 * result + (feedbackForwardingEmailAddressIdentityArn?.hashCode() ?: 0)
        result = 31 * result + (fromEmailAddress?.hashCode() ?: 0)
        result = 31 * result + (fromEmailAddressIdentityArn?.hashCode() ?: 0)
        result = 31 * result + (listManagementOptions?.hashCode() ?: 0)
        result = 31 * result + (replyToAddresses?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SendEmailRequest

        if (configurationSetName != other.configurationSetName) return false
        if (content != other.content) return false
        if (destination != other.destination) return false
        if (emailTags != other.emailTags) return false
        if (feedbackForwardingEmailAddress != other.feedbackForwardingEmailAddress) return false
        if (feedbackForwardingEmailAddressIdentityArn != other.feedbackForwardingEmailAddressIdentityArn) return false
        if (fromEmailAddress != other.fromEmailAddress) return false
        if (fromEmailAddressIdentityArn != other.fromEmailAddressIdentityArn) return false
        if (listManagementOptions != other.listManagementOptions) return false
        if (replyToAddresses != other.replyToAddresses) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sesv2.model.SendEmailRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the configuration set to use when sending the email.
         */
        public var configurationSetName: kotlin.String? = null
        /**
         * An object that contains the body of the message. You can send either a Simple message Raw message or a template Message.
         */
        public var content: aws.sdk.kotlin.services.sesv2.model.EmailContent? = null
        /**
         * An object that contains the recipients of the email message.
         */
        public var destination: aws.sdk.kotlin.services.sesv2.model.Destination? = null
        /**
         * A list of tags, in the form of name/value pairs, to apply to an email that you send using the `SendEmail` operation. Tags correspond to characteristics of the email that you define, so that you can publish email sending events.
         */
        public var emailTags: List<MessageTag>? = null
        /**
         * The address that you want bounce and complaint notifications to be sent to.
         */
        public var feedbackForwardingEmailAddress: kotlin.String? = null
        /**
         * This parameter is used only for sending authorization. It is the ARN of the identity that is associated with the sending authorization policy that permits you to use the email address specified in the `FeedbackForwardingEmailAddress` parameter.
         *
         * For example, if the owner of example.com (which has ARN arn:aws:ses:us-east-1:123456789012:identity/example.com) attaches a policy to it that authorizes you to use feedback@example.com, then you would specify the `FeedbackForwardingEmailAddressIdentityArn` to be arn:aws:ses:us-east-1:123456789012:identity/example.com, and the `FeedbackForwardingEmailAddress` to be feedback@example.com.
         *
         * For more information about sending authorization, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html).
         */
        public var feedbackForwardingEmailAddressIdentityArn: kotlin.String? = null
        /**
         * The email address to use as the "From" address for the email. The address that you specify has to be verified.
         */
        public var fromEmailAddress: kotlin.String? = null
        /**
         * This parameter is used only for sending authorization. It is the ARN of the identity that is associated with the sending authorization policy that permits you to use the email address specified in the `FromEmailAddress` parameter.
         *
         * For example, if the owner of example.com (which has ARN arn:aws:ses:us-east-1:123456789012:identity/example.com) attaches a policy to it that authorizes you to use sender@example.com, then you would specify the `FromEmailAddressIdentityArn` to be arn:aws:ses:us-east-1:123456789012:identity/example.com, and the `FromEmailAddress` to be sender@example.com.
         *
         * For more information about sending authorization, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html).
         *
         * For Raw emails, the `FromEmailAddressIdentityArn` value overrides the X-SES-SOURCE-ARN and X-SES-FROM-ARN headers specified in raw email message content.
         */
        public var fromEmailAddressIdentityArn: kotlin.String? = null
        /**
         * An object used to specify a list or topic to which an email belongs, which will be used when a contact chooses to unsubscribe.
         */
        public var listManagementOptions: aws.sdk.kotlin.services.sesv2.model.ListManagementOptions? = null
        /**
         * The "Reply-to" email addresses for the message. When the recipient replies to the message, each Reply-to address receives the reply.
         */
        public var replyToAddresses: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sesv2.model.SendEmailRequest) : this() {
            this.configurationSetName = x.configurationSetName
            this.content = x.content
            this.destination = x.destination
            this.emailTags = x.emailTags
            this.feedbackForwardingEmailAddress = x.feedbackForwardingEmailAddress
            this.feedbackForwardingEmailAddressIdentityArn = x.feedbackForwardingEmailAddressIdentityArn
            this.fromEmailAddress = x.fromEmailAddress
            this.fromEmailAddressIdentityArn = x.fromEmailAddressIdentityArn
            this.listManagementOptions = x.listManagementOptions
            this.replyToAddresses = x.replyToAddresses
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sesv2.model.SendEmailRequest = SendEmailRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.sesv2.model.EmailContent] inside the given [block]
         */
        public fun content(block: aws.sdk.kotlin.services.sesv2.model.EmailContent.Builder.() -> kotlin.Unit) {
            this.content = aws.sdk.kotlin.services.sesv2.model.EmailContent.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sesv2.model.Destination] inside the given [block]
         */
        public fun destination(block: aws.sdk.kotlin.services.sesv2.model.Destination.Builder.() -> kotlin.Unit) {
            this.destination = aws.sdk.kotlin.services.sesv2.model.Destination.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sesv2.model.ListManagementOptions] inside the given [block]
         */
        public fun listManagementOptions(block: aws.sdk.kotlin.services.sesv2.model.ListManagementOptions.Builder.() -> kotlin.Unit) {
            this.listManagementOptions = aws.sdk.kotlin.services.sesv2.model.ListManagementOptions.invoke(block)
        }
    }
}
