// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sesv2.model



/**
 * An object that defines an Amazon Kinesis Data Firehose destination for email events. You can use Amazon Kinesis Data Firehose to stream data to other services, such as Amazon S3 and Amazon Redshift.
 */
public class KinesisFirehoseDestination private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the Amazon Kinesis Data Firehose stream that the Amazon SES API v2 sends email events to.
     */
    public val deliveryStreamArn: kotlin.String? = builder.deliveryStreamArn
    /**
     * The Amazon Resource Name (ARN) of the IAM role that the Amazon SES API v2 uses to send email events to the Amazon Kinesis Data Firehose stream.
     */
    public val iamRoleArn: kotlin.String? = builder.iamRoleArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sesv2.model.KinesisFirehoseDestination = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("KinesisFirehoseDestination(")
        append("deliveryStreamArn=$deliveryStreamArn,")
        append("iamRoleArn=$iamRoleArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = deliveryStreamArn?.hashCode() ?: 0
        result = 31 * result + (iamRoleArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as KinesisFirehoseDestination

        if (deliveryStreamArn != other.deliveryStreamArn) return false
        if (iamRoleArn != other.iamRoleArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sesv2.model.KinesisFirehoseDestination = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the Amazon Kinesis Data Firehose stream that the Amazon SES API v2 sends email events to.
         */
        public var deliveryStreamArn: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the IAM role that the Amazon SES API v2 uses to send email events to the Amazon Kinesis Data Firehose stream.
         */
        public var iamRoleArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sesv2.model.KinesisFirehoseDestination) : this() {
            this.deliveryStreamArn = x.deliveryStreamArn
            this.iamRoleArn = x.iamRoleArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sesv2.model.KinesisFirehoseDestination = KinesisFirehoseDestination(this)
    }
}
