// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sesv2.model



/**
 * A list of details about the email-sending capabilities of your Amazon SES account in the current Amazon Web Services Region.
 */
public class GetAccountResponse private constructor(builder: Builder) {
    /**
     * Indicates whether or not the automatic warm-up feature is enabled for dedicated IP addresses that are associated with your account.
     */
    public val dedicatedIpAutoWarmupEnabled: kotlin.Boolean = builder.dedicatedIpAutoWarmupEnabled
    /**
     * An object that defines your account details.
     */
    public val details: aws.sdk.kotlin.services.sesv2.model.AccountDetails? = builder.details
    /**
     * The reputation status of your Amazon SES account. The status can be one of the following:
     * + `HEALTHY` – There are no reputation-related issues that currently impact your account.
     * + `PROBATION` – We've identified potential issues with your Amazon SES account. We're placing your account under review while you work on correcting these issues.
     * + `SHUTDOWN` – Your account's ability to send email is currently paused because of an issue with the email sent from your account. When you correct the issue, you can contact us and request that your account's ability to send email is resumed.
     */
    public val enforcementStatus: kotlin.String? = builder.enforcementStatus
    /**
     * Indicates whether or not your account has production access in the current Amazon Web Services Region.
     *
     * If the value is `false`, then your account is in the *sandbox*. When your account is in the sandbox, you can only send email to verified identities. Additionally, the maximum number of emails you can send in a 24-hour period (your sending quota) is 200, and the maximum number of emails you can send per second (your maximum sending rate) is 1.
     *
     * If the value is `true`, then your account has production access. When your account has production access, you can send email to any address. The sending quota and maximum sending rate for your account vary based on your specific use case.
     */
    public val productionAccessEnabled: kotlin.Boolean = builder.productionAccessEnabled
    /**
     * An object that contains information about the per-day and per-second sending limits for your Amazon SES account in the current Amazon Web Services Region.
     */
    public val sendQuota: aws.sdk.kotlin.services.sesv2.model.SendQuota? = builder.sendQuota
    /**
     * Indicates whether or not email sending is enabled for your Amazon SES account in the current Amazon Web Services Region.
     */
    public val sendingEnabled: kotlin.Boolean = builder.sendingEnabled
    /**
     * An object that contains information about the email address suppression preferences for your account in the current Amazon Web Services Region.
     */
    public val suppressionAttributes: aws.sdk.kotlin.services.sesv2.model.SuppressionAttributes? = builder.suppressionAttributes
    /**
     * The VDM attributes that apply to your Amazon SES account.
     */
    public val vdmAttributes: aws.sdk.kotlin.services.sesv2.model.VdmAttributes? = builder.vdmAttributes

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sesv2.model.GetAccountResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetAccountResponse(")
        append("dedicatedIpAutoWarmupEnabled=$dedicatedIpAutoWarmupEnabled,")
        append("details=$details,")
        append("enforcementStatus=$enforcementStatus,")
        append("productionAccessEnabled=$productionAccessEnabled,")
        append("sendQuota=$sendQuota,")
        append("sendingEnabled=$sendingEnabled,")
        append("suppressionAttributes=$suppressionAttributes,")
        append("vdmAttributes=$vdmAttributes")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dedicatedIpAutoWarmupEnabled.hashCode()
        result = 31 * result + (details?.hashCode() ?: 0)
        result = 31 * result + (enforcementStatus?.hashCode() ?: 0)
        result = 31 * result + (productionAccessEnabled.hashCode())
        result = 31 * result + (sendQuota?.hashCode() ?: 0)
        result = 31 * result + (sendingEnabled.hashCode())
        result = 31 * result + (suppressionAttributes?.hashCode() ?: 0)
        result = 31 * result + (vdmAttributes?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetAccountResponse

        if (dedicatedIpAutoWarmupEnabled != other.dedicatedIpAutoWarmupEnabled) return false
        if (details != other.details) return false
        if (enforcementStatus != other.enforcementStatus) return false
        if (productionAccessEnabled != other.productionAccessEnabled) return false
        if (sendQuota != other.sendQuota) return false
        if (sendingEnabled != other.sendingEnabled) return false
        if (suppressionAttributes != other.suppressionAttributes) return false
        if (vdmAttributes != other.vdmAttributes) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sesv2.model.GetAccountResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Indicates whether or not the automatic warm-up feature is enabled for dedicated IP addresses that are associated with your account.
         */
        public var dedicatedIpAutoWarmupEnabled: kotlin.Boolean = false
        /**
         * An object that defines your account details.
         */
        public var details: aws.sdk.kotlin.services.sesv2.model.AccountDetails? = null
        /**
         * The reputation status of your Amazon SES account. The status can be one of the following:
         * + `HEALTHY` – There are no reputation-related issues that currently impact your account.
         * + `PROBATION` – We've identified potential issues with your Amazon SES account. We're placing your account under review while you work on correcting these issues.
         * + `SHUTDOWN` – Your account's ability to send email is currently paused because of an issue with the email sent from your account. When you correct the issue, you can contact us and request that your account's ability to send email is resumed.
         */
        public var enforcementStatus: kotlin.String? = null
        /**
         * Indicates whether or not your account has production access in the current Amazon Web Services Region.
         *
         * If the value is `false`, then your account is in the *sandbox*. When your account is in the sandbox, you can only send email to verified identities. Additionally, the maximum number of emails you can send in a 24-hour period (your sending quota) is 200, and the maximum number of emails you can send per second (your maximum sending rate) is 1.
         *
         * If the value is `true`, then your account has production access. When your account has production access, you can send email to any address. The sending quota and maximum sending rate for your account vary based on your specific use case.
         */
        public var productionAccessEnabled: kotlin.Boolean = false
        /**
         * An object that contains information about the per-day and per-second sending limits for your Amazon SES account in the current Amazon Web Services Region.
         */
        public var sendQuota: aws.sdk.kotlin.services.sesv2.model.SendQuota? = null
        /**
         * Indicates whether or not email sending is enabled for your Amazon SES account in the current Amazon Web Services Region.
         */
        public var sendingEnabled: kotlin.Boolean = false
        /**
         * An object that contains information about the email address suppression preferences for your account in the current Amazon Web Services Region.
         */
        public var suppressionAttributes: aws.sdk.kotlin.services.sesv2.model.SuppressionAttributes? = null
        /**
         * The VDM attributes that apply to your Amazon SES account.
         */
        public var vdmAttributes: aws.sdk.kotlin.services.sesv2.model.VdmAttributes? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sesv2.model.GetAccountResponse) : this() {
            this.dedicatedIpAutoWarmupEnabled = x.dedicatedIpAutoWarmupEnabled
            this.details = x.details
            this.enforcementStatus = x.enforcementStatus
            this.productionAccessEnabled = x.productionAccessEnabled
            this.sendQuota = x.sendQuota
            this.sendingEnabled = x.sendingEnabled
            this.suppressionAttributes = x.suppressionAttributes
            this.vdmAttributes = x.vdmAttributes
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sesv2.model.GetAccountResponse = GetAccountResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.sesv2.model.AccountDetails] inside the given [block]
         */
        public fun details(block: aws.sdk.kotlin.services.sesv2.model.AccountDetails.Builder.() -> kotlin.Unit) {
            this.details = aws.sdk.kotlin.services.sesv2.model.AccountDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sesv2.model.SendQuota] inside the given [block]
         */
        public fun sendQuota(block: aws.sdk.kotlin.services.sesv2.model.SendQuota.Builder.() -> kotlin.Unit) {
            this.sendQuota = aws.sdk.kotlin.services.sesv2.model.SendQuota.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sesv2.model.SuppressionAttributes] inside the given [block]
         */
        public fun suppressionAttributes(block: aws.sdk.kotlin.services.sesv2.model.SuppressionAttributes.Builder.() -> kotlin.Unit) {
            this.suppressionAttributes = aws.sdk.kotlin.services.sesv2.model.SuppressionAttributes.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sesv2.model.VdmAttributes] inside the given [block]
         */
        public fun vdmAttributes(block: aws.sdk.kotlin.services.sesv2.model.VdmAttributes.Builder.() -> kotlin.Unit) {
            this.vdmAttributes = aws.sdk.kotlin.services.sesv2.model.VdmAttributes.invoke(block)
        }
    }
}
