// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sesv2.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * An object that contains information about the DKIM authentication status for an email identity.
 *
 * Amazon SES determines the authentication status by searching for specific records in the DNS configuration for the domain. If you used [Easy DKIM](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html) to set up DKIM authentication, Amazon SES tries to find three unique CNAME records in the DNS configuration for your domain. If you provided a public key to perform DKIM authentication, Amazon SES tries to find a TXT record that uses the selector that you specified. The value of the TXT record must be a public key that's paired with the private key that you specified in the process of creating the identity
 */
public class DkimAttributes private constructor(builder: Builder) {
    /**
     * &#91;Easy DKIM&#93; The key length of the DKIM key pair in use.
     */
    public val currentSigningKeyLength: aws.sdk.kotlin.services.sesv2.model.DkimSigningKeyLength? = builder.currentSigningKeyLength
    /**
     * &#91;Easy DKIM&#93; The last time a key pair was generated for this identity.
     */
    public val lastKeyGenerationTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.lastKeyGenerationTimestamp
    /**
     * &#91;Easy DKIM&#93; The key length of the future DKIM key pair to be generated. This can be changed at most once per day.
     */
    public val nextSigningKeyLength: aws.sdk.kotlin.services.sesv2.model.DkimSigningKeyLength? = builder.nextSigningKeyLength
    /**
     * A string that indicates how DKIM was configured for the identity. These are the possible values:
     * + `AWS_SES` – Indicates that DKIM was configured for the identity by using [Easy DKIM](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html).
     * + `EXTERNAL` – Indicates that DKIM was configured for the identity by using Bring Your Own DKIM (BYODKIM).
     */
    public val signingAttributesOrigin: aws.sdk.kotlin.services.sesv2.model.DkimSigningAttributesOrigin? = builder.signingAttributesOrigin
    /**
     * If the value is `true`, then the messages that you send from the identity are signed using DKIM. If the value is `false`, then the messages that you send from the identity aren't DKIM-signed.
     */
    public val signingEnabled: kotlin.Boolean = builder.signingEnabled
    /**
     * Describes whether or not Amazon SES has successfully located the DKIM records in the DNS records for the domain. The status can be one of the following:
     * + `PENDING` – The verification process was initiated, but Amazon SES hasn't yet detected the DKIM records in the DNS configuration for the domain.
     * + `SUCCESS` – The verification process completed successfully.
     * + `FAILED` – The verification process failed. This typically occurs when Amazon SES fails to find the DKIM records in the DNS configuration of the domain.
     * + `TEMPORARY_FAILURE` – A temporary issue is preventing Amazon SES from determining the DKIM authentication status of the domain.
     * + `NOT_STARTED` – The DKIM verification process hasn't been initiated for the domain.
     */
    public val status: aws.sdk.kotlin.services.sesv2.model.DkimStatus? = builder.status
    /**
     * If you used [Easy DKIM](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html) to configure DKIM authentication for the domain, then this object contains a set of unique strings that you use to create a set of CNAME records that you add to the DNS configuration for your domain. When Amazon SES detects these records in the DNS configuration for your domain, the DKIM authentication process is complete.
     *
     * If you configured DKIM authentication for the domain by providing your own public-private key pair, then this object contains the selector for the public key.
     *
     * Regardless of the DKIM authentication method you use, Amazon SES searches for the appropriate records in the DNS configuration of the domain for up to 72 hours.
     */
    public val tokens: List<String>? = builder.tokens

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sesv2.model.DkimAttributes = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DkimAttributes(")
        append("currentSigningKeyLength=$currentSigningKeyLength,")
        append("lastKeyGenerationTimestamp=$lastKeyGenerationTimestamp,")
        append("nextSigningKeyLength=$nextSigningKeyLength,")
        append("signingAttributesOrigin=$signingAttributesOrigin,")
        append("signingEnabled=$signingEnabled,")
        append("status=$status,")
        append("tokens=$tokens")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = currentSigningKeyLength?.hashCode() ?: 0
        result = 31 * result + (lastKeyGenerationTimestamp?.hashCode() ?: 0)
        result = 31 * result + (nextSigningKeyLength?.hashCode() ?: 0)
        result = 31 * result + (signingAttributesOrigin?.hashCode() ?: 0)
        result = 31 * result + (signingEnabled.hashCode())
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (tokens?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DkimAttributes

        if (currentSigningKeyLength != other.currentSigningKeyLength) return false
        if (lastKeyGenerationTimestamp != other.lastKeyGenerationTimestamp) return false
        if (nextSigningKeyLength != other.nextSigningKeyLength) return false
        if (signingAttributesOrigin != other.signingAttributesOrigin) return false
        if (signingEnabled != other.signingEnabled) return false
        if (status != other.status) return false
        if (tokens != other.tokens) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sesv2.model.DkimAttributes = Builder(this).apply(block).build()

    public class Builder {
        /**
         * &#91;Easy DKIM&#93; The key length of the DKIM key pair in use.
         */
        public var currentSigningKeyLength: aws.sdk.kotlin.services.sesv2.model.DkimSigningKeyLength? = null
        /**
         * &#91;Easy DKIM&#93; The last time a key pair was generated for this identity.
         */
        public var lastKeyGenerationTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * &#91;Easy DKIM&#93; The key length of the future DKIM key pair to be generated. This can be changed at most once per day.
         */
        public var nextSigningKeyLength: aws.sdk.kotlin.services.sesv2.model.DkimSigningKeyLength? = null
        /**
         * A string that indicates how DKIM was configured for the identity. These are the possible values:
         * + `AWS_SES` – Indicates that DKIM was configured for the identity by using [Easy DKIM](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html).
         * + `EXTERNAL` – Indicates that DKIM was configured for the identity by using Bring Your Own DKIM (BYODKIM).
         */
        public var signingAttributesOrigin: aws.sdk.kotlin.services.sesv2.model.DkimSigningAttributesOrigin? = null
        /**
         * If the value is `true`, then the messages that you send from the identity are signed using DKIM. If the value is `false`, then the messages that you send from the identity aren't DKIM-signed.
         */
        public var signingEnabled: kotlin.Boolean = false
        /**
         * Describes whether or not Amazon SES has successfully located the DKIM records in the DNS records for the domain. The status can be one of the following:
         * + `PENDING` – The verification process was initiated, but Amazon SES hasn't yet detected the DKIM records in the DNS configuration for the domain.
         * + `SUCCESS` – The verification process completed successfully.
         * + `FAILED` – The verification process failed. This typically occurs when Amazon SES fails to find the DKIM records in the DNS configuration of the domain.
         * + `TEMPORARY_FAILURE` – A temporary issue is preventing Amazon SES from determining the DKIM authentication status of the domain.
         * + `NOT_STARTED` – The DKIM verification process hasn't been initiated for the domain.
         */
        public var status: aws.sdk.kotlin.services.sesv2.model.DkimStatus? = null
        /**
         * If you used [Easy DKIM](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html) to configure DKIM authentication for the domain, then this object contains a set of unique strings that you use to create a set of CNAME records that you add to the DNS configuration for your domain. When Amazon SES detects these records in the DNS configuration for your domain, the DKIM authentication process is complete.
         *
         * If you configured DKIM authentication for the domain by providing your own public-private key pair, then this object contains the selector for the public key.
         *
         * Regardless of the DKIM authentication method you use, Amazon SES searches for the appropriate records in the DNS configuration of the domain for up to 72 hours.
         */
        public var tokens: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sesv2.model.DkimAttributes) : this() {
            this.currentSigningKeyLength = x.currentSigningKeyLength
            this.lastKeyGenerationTimestamp = x.lastKeyGenerationTimestamp
            this.nextSigningKeyLength = x.nextSigningKeyLength
            this.signingAttributesOrigin = x.signingAttributesOrigin
            this.signingEnabled = x.signingEnabled
            this.status = x.status
            this.tokens = x.tokens
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sesv2.model.DkimAttributes = DkimAttributes(this)
    }
}
