// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sesv2.transform

import aws.sdk.kotlin.services.sesv2.model.GetSuppressedDestinationResponse
import aws.sdk.kotlin.services.sesv2.model.SesV2Exception
import aws.sdk.kotlin.services.sesv2.model.SuppressedDestination
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetSuppressedDestinationOperationDeserializer: HttpDeserialize<GetSuppressedDestinationResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetSuppressedDestinationResponse {
        if (!response.status.isSuccess()) {
            throwGetSuppressedDestinationError(context, response)
        }
        val builder = GetSuppressedDestinationResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetSuppressedDestinationOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetSuppressedDestinationError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw SesV2Exception("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> SesV2Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetSuppressedDestinationOperationBody(builder: GetSuppressedDestinationResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val SUPPRESSEDDESTINATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("SuppressedDestination"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(SUPPRESSEDDESTINATION_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                SUPPRESSEDDESTINATION_DESCRIPTOR.index -> builder.suppressedDestination = deserializeSuppressedDestinationDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
