// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sesv2.model



/**
 * An object that contains inbox placement data for an email provider.
 */
public class PlacementStatistics private constructor(builder: Builder) {
    /**
     * The percentage of emails that were authenticated by using DomainKeys Identified Mail (DKIM) during the predictive inbox placement test.
     */
    public val dkimPercentage: kotlin.Double? = builder.dkimPercentage
    /**
     * The percentage of emails that arrived in recipients' inboxes during the predictive inbox placement test.
     */
    public val inboxPercentage: kotlin.Double? = builder.inboxPercentage
    /**
     * The percentage of emails that didn't arrive in recipients' inboxes at all during the predictive inbox placement test.
     */
    public val missingPercentage: kotlin.Double? = builder.missingPercentage
    /**
     * The percentage of emails that arrived in recipients' spam or junk mail folders during the predictive inbox placement test.
     */
    public val spamPercentage: kotlin.Double? = builder.spamPercentage
    /**
     * The percentage of emails that were authenticated by using Sender Policy Framework (SPF) during the predictive inbox placement test.
     */
    public val spfPercentage: kotlin.Double? = builder.spfPercentage

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sesv2.model.PlacementStatistics = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PlacementStatistics(")
        append("dkimPercentage=$dkimPercentage,")
        append("inboxPercentage=$inboxPercentage,")
        append("missingPercentage=$missingPercentage,")
        append("spamPercentage=$spamPercentage,")
        append("spfPercentage=$spfPercentage")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dkimPercentage?.hashCode() ?: 0
        result = 31 * result + (inboxPercentage?.hashCode() ?: 0)
        result = 31 * result + (missingPercentage?.hashCode() ?: 0)
        result = 31 * result + (spamPercentage?.hashCode() ?: 0)
        result = 31 * result + (spfPercentage?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PlacementStatistics

        if (dkimPercentage != other.dkimPercentage) return false
        if (inboxPercentage != other.inboxPercentage) return false
        if (missingPercentage != other.missingPercentage) return false
        if (spamPercentage != other.spamPercentage) return false
        if (spfPercentage != other.spfPercentage) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sesv2.model.PlacementStatistics = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The percentage of emails that were authenticated by using DomainKeys Identified Mail (DKIM) during the predictive inbox placement test.
         */
        public var dkimPercentage: kotlin.Double? = null
        /**
         * The percentage of emails that arrived in recipients' inboxes during the predictive inbox placement test.
         */
        public var inboxPercentage: kotlin.Double? = null
        /**
         * The percentage of emails that didn't arrive in recipients' inboxes at all during the predictive inbox placement test.
         */
        public var missingPercentage: kotlin.Double? = null
        /**
         * The percentage of emails that arrived in recipients' spam or junk mail folders during the predictive inbox placement test.
         */
        public var spamPercentage: kotlin.Double? = null
        /**
         * The percentage of emails that were authenticated by using Sender Policy Framework (SPF) during the predictive inbox placement test.
         */
        public var spfPercentage: kotlin.Double? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sesv2.model.PlacementStatistics) : this() {
            this.dkimPercentage = x.dkimPercentage
            this.inboxPercentage = x.inboxPercentage
            this.missingPercentage = x.missingPercentage
            this.spamPercentage = x.spamPercentage
            this.spfPercentage = x.spfPercentage
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sesv2.model.PlacementStatistics = PlacementStatistics(this)
    }
}
