// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sesv2.model



/**
 * A request to begin the verification process for an email identity (an email address or domain).
 */
public class CreateEmailIdentityRequest private constructor(builder: Builder) {
    /**
     * The configuration set to use by default when sending from this identity. Note that any configuration set defined in the email sending request takes precedence.
     */
    public val configurationSetName: kotlin.String? = builder.configurationSetName
    /**
     * If your request includes this object, Amazon SES configures the identity to use Bring Your Own DKIM (BYODKIM) for DKIM authentication purposes, or, configures the key length to be used for [Easy DKIM](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html).
     *
     * You can only specify this object if the email identity is a domain, as opposed to an address.
     */
    public val dkimSigningAttributes: aws.sdk.kotlin.services.sesv2.model.DkimSigningAttributes? = builder.dkimSigningAttributes
    /**
     * The email address or domain to verify.
     */
    public val emailIdentity: kotlin.String? = builder.emailIdentity
    /**
     * An array of objects that define the tags (keys and values) to associate with the email identity.
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sesv2.model.CreateEmailIdentityRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateEmailIdentityRequest(")
        append("configurationSetName=$configurationSetName,")
        append("dkimSigningAttributes=$dkimSigningAttributes,")
        append("emailIdentity=$emailIdentity,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = configurationSetName?.hashCode() ?: 0
        result = 31 * result + (dkimSigningAttributes?.hashCode() ?: 0)
        result = 31 * result + (emailIdentity?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateEmailIdentityRequest

        if (configurationSetName != other.configurationSetName) return false
        if (dkimSigningAttributes != other.dkimSigningAttributes) return false
        if (emailIdentity != other.emailIdentity) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sesv2.model.CreateEmailIdentityRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The configuration set to use by default when sending from this identity. Note that any configuration set defined in the email sending request takes precedence.
         */
        public var configurationSetName: kotlin.String? = null
        /**
         * If your request includes this object, Amazon SES configures the identity to use Bring Your Own DKIM (BYODKIM) for DKIM authentication purposes, or, configures the key length to be used for [Easy DKIM](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html).
         *
         * You can only specify this object if the email identity is a domain, as opposed to an address.
         */
        public var dkimSigningAttributes: aws.sdk.kotlin.services.sesv2.model.DkimSigningAttributes? = null
        /**
         * The email address or domain to verify.
         */
        public var emailIdentity: kotlin.String? = null
        /**
         * An array of objects that define the tags (keys and values) to associate with the email identity.
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sesv2.model.CreateEmailIdentityRequest) : this() {
            this.configurationSetName = x.configurationSetName
            this.dkimSigningAttributes = x.dkimSigningAttributes
            this.emailIdentity = x.emailIdentity
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sesv2.model.CreateEmailIdentityRequest = CreateEmailIdentityRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.sesv2.model.DkimSigningAttributes] inside the given [block]
         */
        public fun dkimSigningAttributes(block: aws.sdk.kotlin.services.sesv2.model.DkimSigningAttributes.Builder.() -> kotlin.Unit) {
            this.dkimSigningAttributes = aws.sdk.kotlin.services.sesv2.model.DkimSigningAttributes.invoke(block)
        }
    }
}
