// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ses.serde

import aws.sdk.kotlin.services.ses.model.SendRawEmailResponse
import aws.sdk.kotlin.services.ses.model.SesException
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.DeserializationException
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName


internal class SendRawEmailOperationDeserializer: HttpDeserialize<SendRawEmailResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): SendRawEmailResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwSendRawEmailError(context, call)
        }
        val builder = SendRawEmailResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeSendRawEmailOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwSendRawEmailError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw SesException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "MessageRejected" -> MessageRejectedDeserializer().deserialize(context, wrappedCall)
        "MailFromDomainNotVerifiedException" -> MailFromDomainNotVerifiedExceptionDeserializer().deserialize(context, wrappedCall)
        "AccountSendingPausedException" -> AccountSendingPausedExceptionDeserializer().deserialize(context, wrappedCall)
        "ConfigurationSetSendingPausedException" -> ConfigurationSetSendingPausedExceptionDeserializer().deserialize(context, wrappedCall)
        "ConfigurationSetDoesNotExist" -> ConfigurationSetDoesNotExistExceptionDeserializer().deserialize(context, wrappedCall)
        else -> SesException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeSendRawEmailOperationBody(builder: SendRawEmailResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    // begin unwrap response wrapper
    val resultDescriptor = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("SendRawEmailResult"))
    val wrapperDescriptor = SdkObjectDescriptor.build {
        trait(XmlSerialName("SendRawEmailResponse"))
        field(resultDescriptor)
    }

    val wrapper = deserializer.deserializeStruct(wrapperDescriptor)
    if (wrapper.findNextFieldIndex() != resultDescriptor.index) {
        throw DeserializationException("failed to unwrap SendRawEmail response")
    }
    // end unwrap response wrapper

    val MESSAGEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("MessageId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlNamespace("http://ses.amazonaws.com/doc/2010-12-01/"))
        trait(XmlSerialName("SendRawEmailResult"))
        field(MESSAGEID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                MESSAGEID_DESCRIPTOR.index -> builder.messageId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
