// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ses.serde

import aws.sdk.kotlin.services.ses.model.ConfigurationSet
import aws.sdk.kotlin.services.ses.model.DeliveryOptions
import aws.sdk.kotlin.services.ses.model.DescribeConfigurationSetResponse
import aws.sdk.kotlin.services.ses.model.EventDestination
import aws.sdk.kotlin.services.ses.model.ReputationOptions
import aws.sdk.kotlin.services.ses.model.SesException
import aws.sdk.kotlin.services.ses.model.TrackingOptions
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.DeserializationException
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName
import kotlin.collections.mutableListOf


internal class DescribeConfigurationSetOperationDeserializer: HttpDeserialize<DescribeConfigurationSetResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): DescribeConfigurationSetResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeConfigurationSetError(context, call)
        }
        val builder = DescribeConfigurationSetResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeConfigurationSetOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwDescribeConfigurationSetError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw SesException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ConfigurationSetDoesNotExist" -> ConfigurationSetDoesNotExistExceptionDeserializer().deserialize(context, wrappedCall)
        else -> SesException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeConfigurationSetOperationBody(builder: DescribeConfigurationSetResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    // begin unwrap response wrapper
    val resultDescriptor = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("DescribeConfigurationSetResult"))
    val wrapperDescriptor = SdkObjectDescriptor.build {
        trait(XmlSerialName("DescribeConfigurationSetResponse"))
        field(resultDescriptor)
    }

    val wrapper = deserializer.deserializeStruct(wrapperDescriptor)
    if (wrapper.findNextFieldIndex() != resultDescriptor.index) {
        throw DeserializationException("failed to unwrap DescribeConfigurationSet response")
    }
    // end unwrap response wrapper

    val CONFIGURATIONSET_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("ConfigurationSet"))
    val DELIVERYOPTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("DeliveryOptions"))
    val EVENTDESTINATIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, XmlSerialName("EventDestinations"))
    val REPUTATIONOPTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("ReputationOptions"))
    val TRACKINGOPTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("TrackingOptions"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlNamespace("http://ses.amazonaws.com/doc/2010-12-01/"))
        trait(XmlSerialName("DescribeConfigurationSetResult"))
        field(CONFIGURATIONSET_DESCRIPTOR)
        field(DELIVERYOPTIONS_DESCRIPTOR)
        field(EVENTDESTINATIONS_DESCRIPTOR)
        field(REPUTATIONOPTIONS_DESCRIPTOR)
        field(TRACKINGOPTIONS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CONFIGURATIONSET_DESCRIPTOR.index -> builder.configurationSet = deserializeConfigurationSetDocument(deserializer)
                DELIVERYOPTIONS_DESCRIPTOR.index -> builder.deliveryOptions = deserializeDeliveryOptionsDocument(deserializer)
                EVENTDESTINATIONS_DESCRIPTOR.index -> builder.eventDestinations =
                    deserializer.deserializeList(EVENTDESTINATIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<EventDestination>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeEventDestinationDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                REPUTATIONOPTIONS_DESCRIPTOR.index -> builder.reputationOptions = deserializeReputationOptionsDocument(deserializer)
                TRACKINGOPTIONS_DESCRIPTOR.index -> builder.trackingOptions = deserializeTrackingOptionsDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
