// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ses.paginators

import aws.sdk.kotlin.services.ses.SesClient
import aws.sdk.kotlin.services.ses.model.ListCustomVerificationEmailTemplatesRequest
import aws.sdk.kotlin.services.ses.model.ListCustomVerificationEmailTemplatesResponse
import aws.sdk.kotlin.services.ses.model.ListIdentitiesRequest
import aws.sdk.kotlin.services.ses.model.ListIdentitiesResponse
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListCustomVerificationEmailTemplatesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListCustomVerificationEmailTemplatesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListCustomVerificationEmailTemplatesResponse]
 */
public fun SesClient.listCustomVerificationEmailTemplatesPaginated(initialRequest: ListCustomVerificationEmailTemplatesRequest = ListCustomVerificationEmailTemplatesRequest { }): Flow<ListCustomVerificationEmailTemplatesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listCustomVerificationEmailTemplatesPaginated.listCustomVerificationEmailTemplates(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListCustomVerificationEmailTemplatesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListCustomVerificationEmailTemplatesResponse]
 */
public fun SesClient.listCustomVerificationEmailTemplatesPaginated(block: ListCustomVerificationEmailTemplatesRequest.Builder.() -> Unit): Flow<ListCustomVerificationEmailTemplatesResponse> =
    listCustomVerificationEmailTemplatesPaginated(ListCustomVerificationEmailTemplatesRequest.Builder().apply(block).build())

/**
 * Paginate over [ListIdentitiesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListIdentitiesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListIdentitiesResponse]
 */
public fun SesClient.listIdentitiesPaginated(initialRequest: ListIdentitiesRequest = ListIdentitiesRequest { }): Flow<ListIdentitiesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listIdentitiesPaginated.listIdentities(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListIdentitiesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListIdentitiesResponse]
 */
public fun SesClient.listIdentitiesPaginated(block: ListIdentitiesRequest.Builder.() -> Unit): Flow<ListIdentitiesResponse> =
    listIdentitiesPaginated(ListIdentitiesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listIdentitiesPaginated]
 * to access the nested member [Identity]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Identity]
 */
@JvmName("listIdentitiesResponseIdentity")
public fun Flow<ListIdentitiesResponse>.identities(): Flow<String> =
    transform() { response ->
        response.identities?.forEach {
            emit(it)
        }
    }
