// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ses.model



/**
 * Returns CNAME records that you must publish to the DNS server of your domain to set up Easy DKIM with Amazon SES.
 */
public class VerifyDomainDkimResponse private constructor(builder: Builder) {
    /**
     * A set of character strings that represent the domain's identity. If the identity is an email address, the tokens represent the domain of that address.
     *
     * Using these tokens, you need to create DNS CNAME records that point to DKIM public keys that are hosted by Amazon SES. Amazon Web Services eventually detects that you've updated your DNS records. This detection process might take up to 72 hours. After successful detection, Amazon SES is able to DKIM-sign email originating from that domain. (This only applies to domain identities, not email address identities.)
     *
     * For more information about creating DNS records using DKIM tokens, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/send-email-authentication-dkim-easy.html).
     */
    public val dkimTokens: List<String> = requireNotNull(builder.dkimTokens) { "A non-null value must be provided for dkimTokens" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ses.model.VerifyDomainDkimResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("VerifyDomainDkimResponse(")
        append("dkimTokens=$dkimTokens")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dkimTokens.hashCode()
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as VerifyDomainDkimResponse

        if (dkimTokens != other.dkimTokens) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ses.model.VerifyDomainDkimResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A set of character strings that represent the domain's identity. If the identity is an email address, the tokens represent the domain of that address.
         *
         * Using these tokens, you need to create DNS CNAME records that point to DKIM public keys that are hosted by Amazon SES. Amazon Web Services eventually detects that you've updated your DNS records. This detection process might take up to 72 hours. After successful detection, Amazon SES is able to DKIM-sign email originating from that domain. (This only applies to domain identities, not email address identities.)
         *
         * For more information about creating DNS records using DKIM tokens, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/send-email-authentication-dkim-easy.html).
         */
        public var dkimTokens: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ses.model.VerifyDomainDkimResponse) : this() {
            this.dkimTokens = x.dkimTokens
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ses.model.VerifyDomainDkimResponse = VerifyDomainDkimResponse(this)

        internal fun correctErrors(): Builder {
            if (dkimTokens == null) dkimTokens = emptyList()
            return this
        }
    }
}
