// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ses.model



/**
 * Represents a request to specify the Amazon SNS topic to which Amazon SES publishes bounce, complaint, or delivery notifications for emails sent with that identity as the source. For information about Amazon SES notifications, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/monitor-sending-activity-using-notifications-sns.html).
 */
public class SetIdentityNotificationTopicRequest private constructor(builder: Builder) {
    /**
     * The identity (email address or domain) for the Amazon SNS topic.
     *
     * You can only specify a verified identity for this parameter.
     *
     * You can specify an identity by using its name or by using its Amazon Resource Name (ARN). The following examples are all valid identities: `sender@example.com`, `example.com`, `arn:aws:ses:us-east-1:123456789012:identity/example.com`.
     */
    public val identity: kotlin.String? = builder.identity
    /**
     * The type of notifications that are published to the specified Amazon SNS topic.
     */
    public val notificationType: aws.sdk.kotlin.services.ses.model.NotificationType? = builder.notificationType
    /**
     * The Amazon Resource Name (ARN) of the Amazon SNS topic. If the parameter is omitted from the request or a null value is passed, `SnsTopic` is cleared and publishing is disabled.
     */
    public val snsTopic: kotlin.String? = builder.snsTopic

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ses.model.SetIdentityNotificationTopicRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SetIdentityNotificationTopicRequest(")
        append("identity=$identity,")
        append("notificationType=$notificationType,")
        append("snsTopic=$snsTopic")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = identity?.hashCode() ?: 0
        result = 31 * result + (notificationType?.hashCode() ?: 0)
        result = 31 * result + (snsTopic?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SetIdentityNotificationTopicRequest

        if (identity != other.identity) return false
        if (notificationType != other.notificationType) return false
        if (snsTopic != other.snsTopic) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ses.model.SetIdentityNotificationTopicRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The identity (email address or domain) for the Amazon SNS topic.
         *
         * You can only specify a verified identity for this parameter.
         *
         * You can specify an identity by using its name or by using its Amazon Resource Name (ARN). The following examples are all valid identities: `sender@example.com`, `example.com`, `arn:aws:ses:us-east-1:123456789012:identity/example.com`.
         */
        public var identity: kotlin.String? = null
        /**
         * The type of notifications that are published to the specified Amazon SNS topic.
         */
        public var notificationType: aws.sdk.kotlin.services.ses.model.NotificationType? = null
        /**
         * The Amazon Resource Name (ARN) of the Amazon SNS topic. If the parameter is omitted from the request or a null value is passed, `SnsTopic` is cleared and publishing is disabled.
         */
        public var snsTopic: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ses.model.SetIdentityNotificationTopicRequest) : this() {
            this.identity = x.identity
            this.notificationType = x.notificationType
            this.snsTopic = x.snsTopic
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ses.model.SetIdentityNotificationTopicRequest = SetIdentityNotificationTopicRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
