// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ses.model



/**
 * Represents a request to enable or disable whether Amazon SES forwards you bounce and complaint notifications through email. For information about email feedback forwarding, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/monitor-sending-activity-using-notifications-email.html).
 */
public class SetIdentityFeedbackForwardingEnabledRequest private constructor(builder: Builder) {
    /**
     * Sets whether Amazon SES forwards bounce and complaint notifications as email. `true` specifies that Amazon SES forwards bounce and complaint notifications as email, in addition to any Amazon SNS topic publishing otherwise specified. `false` specifies that Amazon SES publishes bounce and complaint notifications only through Amazon SNS. This value can only be set to `false` when Amazon SNS topics are set for both `Bounce` and `Complaint` notification types.
     */
    public val forwardingEnabled: kotlin.Boolean? = builder.forwardingEnabled
    /**
     * The identity for which to set bounce and complaint notification forwarding. Examples: `user@example.com`, `example.com`.
     */
    public val identity: kotlin.String? = builder.identity

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ses.model.SetIdentityFeedbackForwardingEnabledRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SetIdentityFeedbackForwardingEnabledRequest(")
        append("forwardingEnabled=$forwardingEnabled,")
        append("identity=$identity")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = forwardingEnabled?.hashCode() ?: 0
        result = 31 * result + (identity?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SetIdentityFeedbackForwardingEnabledRequest

        if (forwardingEnabled != other.forwardingEnabled) return false
        if (identity != other.identity) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ses.model.SetIdentityFeedbackForwardingEnabledRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Sets whether Amazon SES forwards bounce and complaint notifications as email. `true` specifies that Amazon SES forwards bounce and complaint notifications as email, in addition to any Amazon SNS topic publishing otherwise specified. `false` specifies that Amazon SES publishes bounce and complaint notifications only through Amazon SNS. This value can only be set to `false` when Amazon SNS topics are set for both `Bounce` and `Complaint` notification types.
         */
        public var forwardingEnabled: kotlin.Boolean? = null
        /**
         * The identity for which to set bounce and complaint notification forwarding. Examples: `user@example.com`, `example.com`.
         */
        public var identity: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ses.model.SetIdentityFeedbackForwardingEnabledRequest) : this() {
            this.forwardingEnabled = x.forwardingEnabled
            this.identity = x.identity
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ses.model.SetIdentityFeedbackForwardingEnabledRequest = SetIdentityFeedbackForwardingEnabledRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
