// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ses.model



/**
 * Represents a request to send a templated email using Amazon SES. For more information, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/send-personalized-email-api.html).
 */
public class SendTemplatedEmailRequest private constructor(builder: Builder) {
    /**
     * The name of the configuration set to use when you send an email using `SendTemplatedEmail`.
     */
    public val configurationSetName: kotlin.String? = builder.configurationSetName
    /**
     * The destination for this email, composed of To:, CC:, and BCC: fields. A Destination can include up to 50 recipients across these three fields.
     */
    public val destination: aws.sdk.kotlin.services.ses.model.Destination? = builder.destination
    /**
     * The reply-to email address(es) for the message. If the recipient replies to the message, each reply-to address receives the reply.
     */
    public val replyToAddresses: List<String>? = builder.replyToAddresses
    /**
     * The email address that bounces and complaints are forwarded to when feedback forwarding is enabled. If the message cannot be delivered to the recipient, then an error message is returned from the recipient's ISP; this message is forwarded to the email address specified by the `ReturnPath` parameter. The `ReturnPath` parameter is never overwritten. This email address must be either individually verified with Amazon SES, or from a domain that has been verified with Amazon SES.
     */
    public val returnPath: kotlin.String? = builder.returnPath
    /**
     * This parameter is used only for sending authorization. It is the ARN of the identity that is associated with the sending authorization policy that permits you to use the email address specified in the `ReturnPath` parameter.
     *
     * For example, if the owner of `example.com` (which has ARN `arn:aws:ses:us-east-1:123456789012:identity/example.com`) attaches a policy to it that authorizes you to use `feedback@example.com`, then you would specify the `ReturnPathArn` to be `arn:aws:ses:us-east-1:123456789012:identity/example.com`, and the `ReturnPath` to be `feedback@example.com`.
     *
     * For more information about sending authorization, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/sending-authorization.html).
     */
    public val returnPathArn: kotlin.String? = builder.returnPathArn
    /**
     * The email address that is sending the email. This email address must be either individually verified with Amazon SES, or from a domain that has been verified with Amazon SES. For information about verifying identities, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/creating-identities.html).
     *
     * If you are sending on behalf of another user and have been permitted to do so by a sending authorization policy, then you must also specify the `SourceArn` parameter. For more information about sending authorization, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/sending-authorization.html).
     *
     * Amazon SES does not support the SMTPUTF8 extension, as described in [RFC6531](https://tools.ietf.org/html/rfc6531). for this reason, The email address string must be 7-bit ASCII. If you want to send to or from email addresses that contain Unicode characters in the domain part of an address, you must encode the domain using Punycode. Punycode is not permitted in the local part of the email address (the part before the @ sign) nor in the "friendly from" name. If you want to use Unicode characters in the "friendly from" name, you must encode the "friendly from" name using MIME encoded-word syntax, as described in [Sending raw email using the Amazon SES API](https://docs.aws.amazon.com/ses/latest/dg/send-email-raw.html). For more information about Punycode, see [RFC 3492](http://tools.ietf.org/html/rfc3492).
     */
    public val source: kotlin.String? = builder.source
    /**
     * This parameter is used only for sending authorization. It is the ARN of the identity that is associated with the sending authorization policy that permits you to send for the email address specified in the `Source` parameter.
     *
     * For example, if the owner of `example.com` (which has ARN `arn:aws:ses:us-east-1:123456789012:identity/example.com`) attaches a policy to it that authorizes you to send from `user@example.com`, then you would specify the `SourceArn` to be `arn:aws:ses:us-east-1:123456789012:identity/example.com`, and the `Source` to be `user@example.com`.
     *
     * For more information about sending authorization, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/sending-authorization.html).
     */
    public val sourceArn: kotlin.String? = builder.sourceArn
    /**
     * A list of tags, in the form of name/value pairs, to apply to an email that you send using `SendTemplatedEmail`. Tags correspond to characteristics of the email that you define, so that you can publish email sending events.
     */
    public val tags: List<MessageTag>? = builder.tags
    /**
     * The template to use when sending this email.
     */
    public val template: kotlin.String? = builder.template
    /**
     * The ARN of the template to use when sending this email.
     */
    public val templateArn: kotlin.String? = builder.templateArn
    /**
     * A list of replacement values to apply to the template. This parameter is a JSON object, typically consisting of key-value pairs in which the keys correspond to replacement tags in the email template.
     */
    public val templateData: kotlin.String? = builder.templateData

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ses.model.SendTemplatedEmailRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SendTemplatedEmailRequest(")
        append("configurationSetName=$configurationSetName,")
        append("destination=$destination,")
        append("replyToAddresses=$replyToAddresses,")
        append("returnPath=$returnPath,")
        append("returnPathArn=$returnPathArn,")
        append("source=$source,")
        append("sourceArn=$sourceArn,")
        append("tags=$tags,")
        append("template=$template,")
        append("templateArn=$templateArn,")
        append("templateData=$templateData")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = configurationSetName?.hashCode() ?: 0
        result = 31 * result + (destination?.hashCode() ?: 0)
        result = 31 * result + (replyToAddresses?.hashCode() ?: 0)
        result = 31 * result + (returnPath?.hashCode() ?: 0)
        result = 31 * result + (returnPathArn?.hashCode() ?: 0)
        result = 31 * result + (source?.hashCode() ?: 0)
        result = 31 * result + (sourceArn?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (template?.hashCode() ?: 0)
        result = 31 * result + (templateArn?.hashCode() ?: 0)
        result = 31 * result + (templateData?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SendTemplatedEmailRequest

        if (configurationSetName != other.configurationSetName) return false
        if (destination != other.destination) return false
        if (replyToAddresses != other.replyToAddresses) return false
        if (returnPath != other.returnPath) return false
        if (returnPathArn != other.returnPathArn) return false
        if (source != other.source) return false
        if (sourceArn != other.sourceArn) return false
        if (tags != other.tags) return false
        if (template != other.template) return false
        if (templateArn != other.templateArn) return false
        if (templateData != other.templateData) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ses.model.SendTemplatedEmailRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the configuration set to use when you send an email using `SendTemplatedEmail`.
         */
        public var configurationSetName: kotlin.String? = null
        /**
         * The destination for this email, composed of To:, CC:, and BCC: fields. A Destination can include up to 50 recipients across these three fields.
         */
        public var destination: aws.sdk.kotlin.services.ses.model.Destination? = null
        /**
         * The reply-to email address(es) for the message. If the recipient replies to the message, each reply-to address receives the reply.
         */
        public var replyToAddresses: List<String>? = null
        /**
         * The email address that bounces and complaints are forwarded to when feedback forwarding is enabled. If the message cannot be delivered to the recipient, then an error message is returned from the recipient's ISP; this message is forwarded to the email address specified by the `ReturnPath` parameter. The `ReturnPath` parameter is never overwritten. This email address must be either individually verified with Amazon SES, or from a domain that has been verified with Amazon SES.
         */
        public var returnPath: kotlin.String? = null
        /**
         * This parameter is used only for sending authorization. It is the ARN of the identity that is associated with the sending authorization policy that permits you to use the email address specified in the `ReturnPath` parameter.
         *
         * For example, if the owner of `example.com` (which has ARN `arn:aws:ses:us-east-1:123456789012:identity/example.com`) attaches a policy to it that authorizes you to use `feedback@example.com`, then you would specify the `ReturnPathArn` to be `arn:aws:ses:us-east-1:123456789012:identity/example.com`, and the `ReturnPath` to be `feedback@example.com`.
         *
         * For more information about sending authorization, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/sending-authorization.html).
         */
        public var returnPathArn: kotlin.String? = null
        /**
         * The email address that is sending the email. This email address must be either individually verified with Amazon SES, or from a domain that has been verified with Amazon SES. For information about verifying identities, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/creating-identities.html).
         *
         * If you are sending on behalf of another user and have been permitted to do so by a sending authorization policy, then you must also specify the `SourceArn` parameter. For more information about sending authorization, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/sending-authorization.html).
         *
         * Amazon SES does not support the SMTPUTF8 extension, as described in [RFC6531](https://tools.ietf.org/html/rfc6531). for this reason, The email address string must be 7-bit ASCII. If you want to send to or from email addresses that contain Unicode characters in the domain part of an address, you must encode the domain using Punycode. Punycode is not permitted in the local part of the email address (the part before the @ sign) nor in the "friendly from" name. If you want to use Unicode characters in the "friendly from" name, you must encode the "friendly from" name using MIME encoded-word syntax, as described in [Sending raw email using the Amazon SES API](https://docs.aws.amazon.com/ses/latest/dg/send-email-raw.html). For more information about Punycode, see [RFC 3492](http://tools.ietf.org/html/rfc3492).
         */
        public var source: kotlin.String? = null
        /**
         * This parameter is used only for sending authorization. It is the ARN of the identity that is associated with the sending authorization policy that permits you to send for the email address specified in the `Source` parameter.
         *
         * For example, if the owner of `example.com` (which has ARN `arn:aws:ses:us-east-1:123456789012:identity/example.com`) attaches a policy to it that authorizes you to send from `user@example.com`, then you would specify the `SourceArn` to be `arn:aws:ses:us-east-1:123456789012:identity/example.com`, and the `Source` to be `user@example.com`.
         *
         * For more information about sending authorization, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/sending-authorization.html).
         */
        public var sourceArn: kotlin.String? = null
        /**
         * A list of tags, in the form of name/value pairs, to apply to an email that you send using `SendTemplatedEmail`. Tags correspond to characteristics of the email that you define, so that you can publish email sending events.
         */
        public var tags: List<MessageTag>? = null
        /**
         * The template to use when sending this email.
         */
        public var template: kotlin.String? = null
        /**
         * The ARN of the template to use when sending this email.
         */
        public var templateArn: kotlin.String? = null
        /**
         * A list of replacement values to apply to the template. This parameter is a JSON object, typically consisting of key-value pairs in which the keys correspond to replacement tags in the email template.
         */
        public var templateData: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ses.model.SendTemplatedEmailRequest) : this() {
            this.configurationSetName = x.configurationSetName
            this.destination = x.destination
            this.replyToAddresses = x.replyToAddresses
            this.returnPath = x.returnPath
            this.returnPathArn = x.returnPathArn
            this.source = x.source
            this.sourceArn = x.sourceArn
            this.tags = x.tags
            this.template = x.template
            this.templateArn = x.templateArn
            this.templateData = x.templateData
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ses.model.SendTemplatedEmailRequest = SendTemplatedEmailRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.ses.model.Destination] inside the given [block]
         */
        public fun destination(block: aws.sdk.kotlin.services.ses.model.Destination.Builder.() -> kotlin.Unit) {
            this.destination = aws.sdk.kotlin.services.ses.model.Destination.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
