// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ses.model



/**
 * Represents a request to send a single raw email using Amazon SES. For more information, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/send-email-raw.html).
 */
public class SendRawEmailRequest private constructor(builder: Builder) {
    /**
     * The name of the configuration set to use when you send an email using `SendRawEmail`.
     */
    public val configurationSetName: kotlin.String? = builder.configurationSetName
    /**
     * A list of destinations for the message, consisting of To:, CC:, and BCC: addresses.
     */
    public val destinations: List<String>? = builder.destinations
    /**
     * This parameter is used only for sending authorization. It is the ARN of the identity that is associated with the sending authorization policy that permits you to specify a particular "From" address in the header of the raw email.
     *
     * Instead of using this parameter, you can use the X-header `X-SES-FROM-ARN` in the raw message of the email. If you use both the `FromArn` parameter and the corresponding X-header, Amazon SES uses the value of the `FromArn` parameter.
     *
     * For information about when to use this parameter, see the description of `SendRawEmail` in this guide, or see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/sending-authorization-delegate-sender-tasks-email.html).
     */
    public val fromArn: kotlin.String? = builder.fromArn
    /**
     * The raw email message itself. The message has to meet the following criteria:
     * + The message has to contain a header and a body, separated by a blank line.
     * + All of the required header fields must be present in the message.
     * + Each part of a multipart MIME message must be formatted properly.
     * + Attachments must be of a content type that Amazon SES supports. For a list on unsupported content types, see [Unsupported Attachment Types](https://docs.aws.amazon.com/ses/latest/dg/mime-types.html) in the *Amazon SES Developer Guide*.
     * + The entire message must be base64-encoded.
     * + If any of the MIME parts in your message contain content that is outside of the 7-bit ASCII character range, we highly recommend that you encode that content. For more information, see [Sending Raw Email](https://docs.aws.amazon.com/ses/latest/dg/send-email-raw.html) in the *Amazon SES Developer Guide*.
     * + Per [RFC 5321](https://tools.ietf.org/html/rfc5321#section-4.5.3.1.6), the maximum length of each line of text, including the <crlf>, must not exceed 1,000 characters.
     */
    public val rawMessage: aws.sdk.kotlin.services.ses.model.RawMessage? = builder.rawMessage
    /**
     * This parameter is used only for sending authorization. It is the ARN of the identity that is associated with the sending authorization policy that permits you to use the email address specified in the `ReturnPath` parameter.
     *
     * For example, if the owner of `example.com` (which has ARN `arn:aws:ses:us-east-1:123456789012:identity/example.com`) attaches a policy to it that authorizes you to use `feedback@example.com`, then you would specify the `ReturnPathArn` to be `arn:aws:ses:us-east-1:123456789012:identity/example.com`, and the `ReturnPath` to be `feedback@example.com`.
     *
     * Instead of using this parameter, you can use the X-header `X-SES-RETURN-PATH-ARN` in the raw message of the email. If you use both the `ReturnPathArn` parameter and the corresponding X-header, Amazon SES uses the value of the `ReturnPathArn` parameter.
     *
     * For information about when to use this parameter, see the description of `SendRawEmail` in this guide, or see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/sending-authorization-delegate-sender-tasks-email.html).
     */
    public val returnPathArn: kotlin.String? = builder.returnPathArn
    /**
     * The identity's email address. If you do not provide a value for this parameter, you must specify a "From" address in the raw text of the message. (You can also specify both.)
     *
     * Amazon SES does not support the SMTPUTF8 extension, as described in[RFC6531](https://tools.ietf.org/html/rfc6531). For this reason, the email address string must be 7-bit ASCII. If you want to send to or from email addresses that contain Unicode characters in the domain part of an address, you must encode the domain using Punycode. Punycode is not permitted in the local part of the email address (the part before the @ sign) nor in the "friendly from" name. If you want to use Unicode characters in the "friendly from" name, you must encode the "friendly from" name using MIME encoded-word syntax, as described in [Sending raw email using the Amazon SES API](https://docs.aws.amazon.com/ses/latest/dg/send-email-raw.html). For more information about Punycode, see [RFC 3492](http://tools.ietf.org/html/rfc3492).
     *
     * If you specify the `Source` parameter and have feedback forwarding enabled, then bounces and complaints are sent to this email address. This takes precedence over any Return-Path header that you might include in the raw text of the message.
     */
    public val source: kotlin.String? = builder.source
    /**
     * This parameter is used only for sending authorization. It is the ARN of the identity that is associated with the sending authorization policy that permits you to send for the email address specified in the `Source` parameter.
     *
     * For example, if the owner of `example.com` (which has ARN `arn:aws:ses:us-east-1:123456789012:identity/example.com`) attaches a policy to it that authorizes you to send from `user@example.com`, then you would specify the `SourceArn` to be `arn:aws:ses:us-east-1:123456789012:identity/example.com`, and the `Source` to be `user@example.com`.
     *
     * Instead of using this parameter, you can use the X-header `X-SES-SOURCE-ARN` in the raw message of the email. If you use both the `SourceArn` parameter and the corresponding X-header, Amazon SES uses the value of the `SourceArn` parameter.
     *
     * For information about when to use this parameter, see the description of `SendRawEmail` in this guide, or see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/sending-authorization-delegate-sender-tasks-email.html).
     */
    public val sourceArn: kotlin.String? = builder.sourceArn
    /**
     * A list of tags, in the form of name/value pairs, to apply to an email that you send using `SendRawEmail`. Tags correspond to characteristics of the email that you define, so that you can publish email sending events.
     */
    public val tags: List<MessageTag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ses.model.SendRawEmailRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SendRawEmailRequest(")
        append("configurationSetName=$configurationSetName,")
        append("destinations=$destinations,")
        append("fromArn=$fromArn,")
        append("rawMessage=$rawMessage,")
        append("returnPathArn=$returnPathArn,")
        append("source=$source,")
        append("sourceArn=$sourceArn,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = configurationSetName?.hashCode() ?: 0
        result = 31 * result + (destinations?.hashCode() ?: 0)
        result = 31 * result + (fromArn?.hashCode() ?: 0)
        result = 31 * result + (rawMessage?.hashCode() ?: 0)
        result = 31 * result + (returnPathArn?.hashCode() ?: 0)
        result = 31 * result + (source?.hashCode() ?: 0)
        result = 31 * result + (sourceArn?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SendRawEmailRequest

        if (configurationSetName != other.configurationSetName) return false
        if (destinations != other.destinations) return false
        if (fromArn != other.fromArn) return false
        if (rawMessage != other.rawMessage) return false
        if (returnPathArn != other.returnPathArn) return false
        if (source != other.source) return false
        if (sourceArn != other.sourceArn) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ses.model.SendRawEmailRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the configuration set to use when you send an email using `SendRawEmail`.
         */
        public var configurationSetName: kotlin.String? = null
        /**
         * A list of destinations for the message, consisting of To:, CC:, and BCC: addresses.
         */
        public var destinations: List<String>? = null
        /**
         * This parameter is used only for sending authorization. It is the ARN of the identity that is associated with the sending authorization policy that permits you to specify a particular "From" address in the header of the raw email.
         *
         * Instead of using this parameter, you can use the X-header `X-SES-FROM-ARN` in the raw message of the email. If you use both the `FromArn` parameter and the corresponding X-header, Amazon SES uses the value of the `FromArn` parameter.
         *
         * For information about when to use this parameter, see the description of `SendRawEmail` in this guide, or see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/sending-authorization-delegate-sender-tasks-email.html).
         */
        public var fromArn: kotlin.String? = null
        /**
         * The raw email message itself. The message has to meet the following criteria:
         * + The message has to contain a header and a body, separated by a blank line.
         * + All of the required header fields must be present in the message.
         * + Each part of a multipart MIME message must be formatted properly.
         * + Attachments must be of a content type that Amazon SES supports. For a list on unsupported content types, see [Unsupported Attachment Types](https://docs.aws.amazon.com/ses/latest/dg/mime-types.html) in the *Amazon SES Developer Guide*.
         * + The entire message must be base64-encoded.
         * + If any of the MIME parts in your message contain content that is outside of the 7-bit ASCII character range, we highly recommend that you encode that content. For more information, see [Sending Raw Email](https://docs.aws.amazon.com/ses/latest/dg/send-email-raw.html) in the *Amazon SES Developer Guide*.
         * + Per [RFC 5321](https://tools.ietf.org/html/rfc5321#section-4.5.3.1.6), the maximum length of each line of text, including the <crlf>, must not exceed 1,000 characters.
         */
        public var rawMessage: aws.sdk.kotlin.services.ses.model.RawMessage? = null
        /**
         * This parameter is used only for sending authorization. It is the ARN of the identity that is associated with the sending authorization policy that permits you to use the email address specified in the `ReturnPath` parameter.
         *
         * For example, if the owner of `example.com` (which has ARN `arn:aws:ses:us-east-1:123456789012:identity/example.com`) attaches a policy to it that authorizes you to use `feedback@example.com`, then you would specify the `ReturnPathArn` to be `arn:aws:ses:us-east-1:123456789012:identity/example.com`, and the `ReturnPath` to be `feedback@example.com`.
         *
         * Instead of using this parameter, you can use the X-header `X-SES-RETURN-PATH-ARN` in the raw message of the email. If you use both the `ReturnPathArn` parameter and the corresponding X-header, Amazon SES uses the value of the `ReturnPathArn` parameter.
         *
         * For information about when to use this parameter, see the description of `SendRawEmail` in this guide, or see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/sending-authorization-delegate-sender-tasks-email.html).
         */
        public var returnPathArn: kotlin.String? = null
        /**
         * The identity's email address. If you do not provide a value for this parameter, you must specify a "From" address in the raw text of the message. (You can also specify both.)
         *
         * Amazon SES does not support the SMTPUTF8 extension, as described in[RFC6531](https://tools.ietf.org/html/rfc6531). For this reason, the email address string must be 7-bit ASCII. If you want to send to or from email addresses that contain Unicode characters in the domain part of an address, you must encode the domain using Punycode. Punycode is not permitted in the local part of the email address (the part before the @ sign) nor in the "friendly from" name. If you want to use Unicode characters in the "friendly from" name, you must encode the "friendly from" name using MIME encoded-word syntax, as described in [Sending raw email using the Amazon SES API](https://docs.aws.amazon.com/ses/latest/dg/send-email-raw.html). For more information about Punycode, see [RFC 3492](http://tools.ietf.org/html/rfc3492).
         *
         * If you specify the `Source` parameter and have feedback forwarding enabled, then bounces and complaints are sent to this email address. This takes precedence over any Return-Path header that you might include in the raw text of the message.
         */
        public var source: kotlin.String? = null
        /**
         * This parameter is used only for sending authorization. It is the ARN of the identity that is associated with the sending authorization policy that permits you to send for the email address specified in the `Source` parameter.
         *
         * For example, if the owner of `example.com` (which has ARN `arn:aws:ses:us-east-1:123456789012:identity/example.com`) attaches a policy to it that authorizes you to send from `user@example.com`, then you would specify the `SourceArn` to be `arn:aws:ses:us-east-1:123456789012:identity/example.com`, and the `Source` to be `user@example.com`.
         *
         * Instead of using this parameter, you can use the X-header `X-SES-SOURCE-ARN` in the raw message of the email. If you use both the `SourceArn` parameter and the corresponding X-header, Amazon SES uses the value of the `SourceArn` parameter.
         *
         * For information about when to use this parameter, see the description of `SendRawEmail` in this guide, or see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/sending-authorization-delegate-sender-tasks-email.html).
         */
        public var sourceArn: kotlin.String? = null
        /**
         * A list of tags, in the form of name/value pairs, to apply to an email that you send using `SendRawEmail`. Tags correspond to characteristics of the email that you define, so that you can publish email sending events.
         */
        public var tags: List<MessageTag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ses.model.SendRawEmailRequest) : this() {
            this.configurationSetName = x.configurationSetName
            this.destinations = x.destinations
            this.fromArn = x.fromArn
            this.rawMessage = x.rawMessage
            this.returnPathArn = x.returnPathArn
            this.source = x.source
            this.sourceArn = x.sourceArn
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ses.model.SendRawEmailRequest = SendRawEmailRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.ses.model.RawMessage] inside the given [block]
         */
        public fun rawMessage(block: aws.sdk.kotlin.services.ses.model.RawMessage.Builder.() -> kotlin.Unit) {
            this.rawMessage = aws.sdk.kotlin.services.ses.model.RawMessage.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
