// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ses.model



/**
 * Represents a request to send a single formatted email using Amazon SES. For more information, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/send-email-formatted.html).
 */
public class SendEmailRequest private constructor(builder: Builder) {
    /**
     * The name of the configuration set to use when you send an email using `SendEmail`.
     */
    public val configurationSetName: kotlin.String? = builder.configurationSetName
    /**
     * The destination for this email, composed of To:, CC:, and BCC: fields.
     */
    public val destination: aws.sdk.kotlin.services.ses.model.Destination? = builder.destination
    /**
     * The message to be sent.
     */
    public val message: aws.sdk.kotlin.services.ses.model.Message? = builder.message
    /**
     * The reply-to email address(es) for the message. If the recipient replies to the message, each reply-to address receives the reply.
     */
    public val replyToAddresses: List<String>? = builder.replyToAddresses
    /**
     * The email address that bounces and complaints are forwarded to when feedback forwarding is enabled. If the message cannot be delivered to the recipient, then an error message is returned from the recipient's ISP; this message is forwarded to the email address specified by the `ReturnPath` parameter. The `ReturnPath` parameter is never overwritten. This email address must be either individually verified with Amazon SES, or from a domain that has been verified with Amazon SES.
     */
    public val returnPath: kotlin.String? = builder.returnPath
    /**
     * This parameter is used only for sending authorization. It is the ARN of the identity that is associated with the sending authorization policy that permits you to use the email address specified in the `ReturnPath` parameter.
     *
     * For example, if the owner of `example.com` (which has ARN `arn:aws:ses:us-east-1:123456789012:identity/example.com`) attaches a policy to it that authorizes you to use `feedback@example.com`, then you would specify the `ReturnPathArn` to be `arn:aws:ses:us-east-1:123456789012:identity/example.com`, and the `ReturnPath` to be `feedback@example.com`.
     *
     * For more information about sending authorization, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/sending-authorization.html).
     */
    public val returnPathArn: kotlin.String? = builder.returnPathArn
    /**
     * The email address that is sending the email. This email address must be either individually verified with Amazon SES, or from a domain that has been verified with Amazon SES. For information about verifying identities, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/creating-identities.html).
     *
     * If you are sending on behalf of another user and have been permitted to do so by a sending authorization policy, then you must also specify the `SourceArn` parameter. For more information about sending authorization, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/sending-authorization.html).
     *
     * Amazon SES does not support the SMTPUTF8 extension, as described in [RFC6531](https://tools.ietf.org/html/rfc6531). For this reason, the email address string must be 7-bit ASCII. If you want to send to or from email addresses that contain Unicode characters in the domain part of an address, you must encode the domain using Punycode. Punycode is not permitted in the local part of the email address (the part before the @ sign) nor in the "friendly from" name. If you want to use Unicode characters in the "friendly from" name, you must encode the "friendly from" name using MIME encoded-word syntax, as described in [Sending raw email using the Amazon SES API](https://docs.aws.amazon.com/ses/latest/dg/send-email-raw.html). For more information about Punycode, see [RFC 3492](http://tools.ietf.org/html/rfc3492).
     */
    public val source: kotlin.String? = builder.source
    /**
     * This parameter is used only for sending authorization. It is the ARN of the identity that is associated with the sending authorization policy that permits you to send for the email address specified in the `Source` parameter.
     *
     * For example, if the owner of `example.com` (which has ARN `arn:aws:ses:us-east-1:123456789012:identity/example.com`) attaches a policy to it that authorizes you to send from `user@example.com`, then you would specify the `SourceArn` to be `arn:aws:ses:us-east-1:123456789012:identity/example.com`, and the `Source` to be `user@example.com`.
     *
     * For more information about sending authorization, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/sending-authorization.html).
     */
    public val sourceArn: kotlin.String? = builder.sourceArn
    /**
     * A list of tags, in the form of name/value pairs, to apply to an email that you send using `SendEmail`. Tags correspond to characteristics of the email that you define, so that you can publish email sending events.
     */
    public val tags: List<MessageTag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ses.model.SendEmailRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SendEmailRequest(")
        append("configurationSetName=$configurationSetName,")
        append("destination=$destination,")
        append("message=$message,")
        append("replyToAddresses=$replyToAddresses,")
        append("returnPath=$returnPath,")
        append("returnPathArn=$returnPathArn,")
        append("source=$source,")
        append("sourceArn=$sourceArn,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = configurationSetName?.hashCode() ?: 0
        result = 31 * result + (destination?.hashCode() ?: 0)
        result = 31 * result + (message?.hashCode() ?: 0)
        result = 31 * result + (replyToAddresses?.hashCode() ?: 0)
        result = 31 * result + (returnPath?.hashCode() ?: 0)
        result = 31 * result + (returnPathArn?.hashCode() ?: 0)
        result = 31 * result + (source?.hashCode() ?: 0)
        result = 31 * result + (sourceArn?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SendEmailRequest

        if (configurationSetName != other.configurationSetName) return false
        if (destination != other.destination) return false
        if (message != other.message) return false
        if (replyToAddresses != other.replyToAddresses) return false
        if (returnPath != other.returnPath) return false
        if (returnPathArn != other.returnPathArn) return false
        if (source != other.source) return false
        if (sourceArn != other.sourceArn) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ses.model.SendEmailRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the configuration set to use when you send an email using `SendEmail`.
         */
        public var configurationSetName: kotlin.String? = null
        /**
         * The destination for this email, composed of To:, CC:, and BCC: fields.
         */
        public var destination: aws.sdk.kotlin.services.ses.model.Destination? = null
        /**
         * The message to be sent.
         */
        public var message: aws.sdk.kotlin.services.ses.model.Message? = null
        /**
         * The reply-to email address(es) for the message. If the recipient replies to the message, each reply-to address receives the reply.
         */
        public var replyToAddresses: List<String>? = null
        /**
         * The email address that bounces and complaints are forwarded to when feedback forwarding is enabled. If the message cannot be delivered to the recipient, then an error message is returned from the recipient's ISP; this message is forwarded to the email address specified by the `ReturnPath` parameter. The `ReturnPath` parameter is never overwritten. This email address must be either individually verified with Amazon SES, or from a domain that has been verified with Amazon SES.
         */
        public var returnPath: kotlin.String? = null
        /**
         * This parameter is used only for sending authorization. It is the ARN of the identity that is associated with the sending authorization policy that permits you to use the email address specified in the `ReturnPath` parameter.
         *
         * For example, if the owner of `example.com` (which has ARN `arn:aws:ses:us-east-1:123456789012:identity/example.com`) attaches a policy to it that authorizes you to use `feedback@example.com`, then you would specify the `ReturnPathArn` to be `arn:aws:ses:us-east-1:123456789012:identity/example.com`, and the `ReturnPath` to be `feedback@example.com`.
         *
         * For more information about sending authorization, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/sending-authorization.html).
         */
        public var returnPathArn: kotlin.String? = null
        /**
         * The email address that is sending the email. This email address must be either individually verified with Amazon SES, or from a domain that has been verified with Amazon SES. For information about verifying identities, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/creating-identities.html).
         *
         * If you are sending on behalf of another user and have been permitted to do so by a sending authorization policy, then you must also specify the `SourceArn` parameter. For more information about sending authorization, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/sending-authorization.html).
         *
         * Amazon SES does not support the SMTPUTF8 extension, as described in [RFC6531](https://tools.ietf.org/html/rfc6531). For this reason, the email address string must be 7-bit ASCII. If you want to send to or from email addresses that contain Unicode characters in the domain part of an address, you must encode the domain using Punycode. Punycode is not permitted in the local part of the email address (the part before the @ sign) nor in the "friendly from" name. If you want to use Unicode characters in the "friendly from" name, you must encode the "friendly from" name using MIME encoded-word syntax, as described in [Sending raw email using the Amazon SES API](https://docs.aws.amazon.com/ses/latest/dg/send-email-raw.html). For more information about Punycode, see [RFC 3492](http://tools.ietf.org/html/rfc3492).
         */
        public var source: kotlin.String? = null
        /**
         * This parameter is used only for sending authorization. It is the ARN of the identity that is associated with the sending authorization policy that permits you to send for the email address specified in the `Source` parameter.
         *
         * For example, if the owner of `example.com` (which has ARN `arn:aws:ses:us-east-1:123456789012:identity/example.com`) attaches a policy to it that authorizes you to send from `user@example.com`, then you would specify the `SourceArn` to be `arn:aws:ses:us-east-1:123456789012:identity/example.com`, and the `Source` to be `user@example.com`.
         *
         * For more information about sending authorization, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/sending-authorization.html).
         */
        public var sourceArn: kotlin.String? = null
        /**
         * A list of tags, in the form of name/value pairs, to apply to an email that you send using `SendEmail`. Tags correspond to characteristics of the email that you define, so that you can publish email sending events.
         */
        public var tags: List<MessageTag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ses.model.SendEmailRequest) : this() {
            this.configurationSetName = x.configurationSetName
            this.destination = x.destination
            this.message = x.message
            this.replyToAddresses = x.replyToAddresses
            this.returnPath = x.returnPath
            this.returnPathArn = x.returnPathArn
            this.source = x.source
            this.sourceArn = x.sourceArn
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ses.model.SendEmailRequest = SendEmailRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.ses.model.Destination] inside the given [block]
         */
        public fun destination(block: aws.sdk.kotlin.services.ses.model.Destination.Builder.() -> kotlin.Unit) {
            this.destination = aws.sdk.kotlin.services.ses.model.Destination.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ses.model.Message] inside the given [block]
         */
        public fun message(block: aws.sdk.kotlin.services.ses.model.Message.Builder.() -> kotlin.Unit) {
            this.message = aws.sdk.kotlin.services.ses.model.Message.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
