// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ses.model



/**
 * When included in a receipt rule, this action saves the received message to an Amazon Simple Storage Service (Amazon S3) bucket and, optionally, publishes a notification to Amazon Simple Notification Service (Amazon SNS).
 *
 * To enable Amazon SES to write emails to your Amazon S3 bucket, use an Amazon Web Services KMS key to encrypt your emails, or publish to an Amazon SNS topic of another account, Amazon SES must have permission to access those resources. For information about granting permissions, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/receiving-email-permissions.html).
 *
 * When you save your emails to an Amazon S3 bucket, the maximum email size (including headers) is 40 MB. Emails larger than that bounces.
 *
 * For information about specifying Amazon S3 actions in receipt rules, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/receiving-email-action-s3.html).
 */
public class S3Action private constructor(builder: Builder) {
    /**
     * The name of the Amazon S3 bucket for incoming email.
     */
    public val bucketName: kotlin.String = requireNotNull(builder.bucketName) { "A non-null value must be provided for bucketName" }
    /**
     * The customer master key that Amazon SES should use to encrypt your emails before saving them to the Amazon S3 bucket. You can use the default master key or a custom master key that you created in Amazon Web Services KMS as follows:
     * + To use the default master key, provide an ARN in the form of `arn:aws:kms:REGION:ACCOUNT-ID-WITHOUT-HYPHENS:alias/aws/ses`. For example, if your Amazon Web Services account ID is 123456789012 and you want to use the default master key in the US West (Oregon) Region, the ARN of the default master key would be `arn:aws:kms:us-west-2:123456789012:alias/aws/ses`. If you use the default master key, you don't need to perform any extra steps to give Amazon SES permission to use the key.
     * + To use a custom master key that you created in Amazon Web Services KMS, provide the ARN of the master key and ensure that you add a statement to your key's policy to give Amazon SES permission to use it. For more information about giving permissions, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/receiving-email-permissions.html).
     *
     * For more information about key policies, see the [Amazon Web Services KMS Developer Guide](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html). If you do not specify a master key, Amazon SES does not encrypt your emails.
     *
     * Your mail is encrypted by Amazon SES using the Amazon S3 encryption client before the mail is submitted to Amazon S3 for storage. It is not encrypted using Amazon S3 server-side encryption. This means that you must use the Amazon S3 encryption client to decrypt the email after retrieving it from Amazon S3, as the service has no access to use your Amazon Web Services KMS keys for decryption. This encryption client is currently available with the [Amazon Web Services SDK for Java](http://aws.amazon.com/sdk-for-java/) and [Amazon Web Services SDK for Ruby](http://aws.amazon.com/sdk-for-ruby/) only. For more information about client-side encryption using Amazon Web Services KMS master keys, see the [Amazon S3 Developer Guide](https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingClientSideEncryption.html).
     */
    public val kmsKeyArn: kotlin.String? = builder.kmsKeyArn
    /**
     * The key prefix of the Amazon S3 bucket. The key prefix is similar to a directory name that enables you to store similar data under the same directory in a bucket.
     */
    public val objectKeyPrefix: kotlin.String? = builder.objectKeyPrefix
    /**
     * The ARN of the Amazon SNS topic to notify when the message is saved to the Amazon S3 bucket. You can find the ARN of a topic by using the [ListTopics](https://docs.aws.amazon.com/sns/latest/api/API_ListTopics.html) operation in Amazon SNS.
     *
     * For more information about Amazon SNS topics, see the [Amazon SNS Developer Guide](https://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html).
     */
    public val topicArn: kotlin.String? = builder.topicArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ses.model.S3Action = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("S3Action(")
        append("bucketName=$bucketName,")
        append("kmsKeyArn=$kmsKeyArn,")
        append("objectKeyPrefix=$objectKeyPrefix,")
        append("topicArn=$topicArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = bucketName.hashCode()
        result = 31 * result + (kmsKeyArn?.hashCode() ?: 0)
        result = 31 * result + (objectKeyPrefix?.hashCode() ?: 0)
        result = 31 * result + (topicArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as S3Action

        if (bucketName != other.bucketName) return false
        if (kmsKeyArn != other.kmsKeyArn) return false
        if (objectKeyPrefix != other.objectKeyPrefix) return false
        if (topicArn != other.topicArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ses.model.S3Action = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the Amazon S3 bucket for incoming email.
         */
        public var bucketName: kotlin.String? = null
        /**
         * The customer master key that Amazon SES should use to encrypt your emails before saving them to the Amazon S3 bucket. You can use the default master key or a custom master key that you created in Amazon Web Services KMS as follows:
         * + To use the default master key, provide an ARN in the form of `arn:aws:kms:REGION:ACCOUNT-ID-WITHOUT-HYPHENS:alias/aws/ses`. For example, if your Amazon Web Services account ID is 123456789012 and you want to use the default master key in the US West (Oregon) Region, the ARN of the default master key would be `arn:aws:kms:us-west-2:123456789012:alias/aws/ses`. If you use the default master key, you don't need to perform any extra steps to give Amazon SES permission to use the key.
         * + To use a custom master key that you created in Amazon Web Services KMS, provide the ARN of the master key and ensure that you add a statement to your key's policy to give Amazon SES permission to use it. For more information about giving permissions, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/receiving-email-permissions.html).
         *
         * For more information about key policies, see the [Amazon Web Services KMS Developer Guide](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html). If you do not specify a master key, Amazon SES does not encrypt your emails.
         *
         * Your mail is encrypted by Amazon SES using the Amazon S3 encryption client before the mail is submitted to Amazon S3 for storage. It is not encrypted using Amazon S3 server-side encryption. This means that you must use the Amazon S3 encryption client to decrypt the email after retrieving it from Amazon S3, as the service has no access to use your Amazon Web Services KMS keys for decryption. This encryption client is currently available with the [Amazon Web Services SDK for Java](http://aws.amazon.com/sdk-for-java/) and [Amazon Web Services SDK for Ruby](http://aws.amazon.com/sdk-for-ruby/) only. For more information about client-side encryption using Amazon Web Services KMS master keys, see the [Amazon S3 Developer Guide](https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingClientSideEncryption.html).
         */
        public var kmsKeyArn: kotlin.String? = null
        /**
         * The key prefix of the Amazon S3 bucket. The key prefix is similar to a directory name that enables you to store similar data under the same directory in a bucket.
         */
        public var objectKeyPrefix: kotlin.String? = null
        /**
         * The ARN of the Amazon SNS topic to notify when the message is saved to the Amazon S3 bucket. You can find the ARN of a topic by using the [ListTopics](https://docs.aws.amazon.com/sns/latest/api/API_ListTopics.html) operation in Amazon SNS.
         *
         * For more information about Amazon SNS topics, see the [Amazon SNS Developer Guide](https://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html).
         */
        public var topicArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ses.model.S3Action) : this() {
            this.bucketName = x.bucketName
            this.kmsKeyArn = x.kmsKeyArn
            this.objectKeyPrefix = x.objectKeyPrefix
            this.topicArn = x.topicArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ses.model.S3Action = S3Action(this)

        internal fun correctErrors(): Builder {
            if (bucketName == null) bucketName = ""
            return this
        }
    }
}
