// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ses.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information about a receipt rule set.
 *
 * A receipt rule set is a collection of rules that specify what Amazon SES should do with mail it receives on behalf of your account's verified domains.
 *
 * For information about setting up receipt rule sets, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/receiving-email-concepts.html#receiving-email-concepts-rules).
 */
public class ReceiptRuleSetMetadata private constructor(builder: Builder) {
    /**
     * The date and time the receipt rule set was created.
     */
    public val createdTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.createdTimestamp
    /**
     * The name of the receipt rule set. The name must meet the following requirements:
     * + Contain only ASCII letters (a-z, A-Z), numbers (0-9), underscores (_), or dashes (-).
     * + Start and end with a letter or number.
     * + Contain 64 characters or fewer.
     */
    public val name: kotlin.String? = builder.name

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ses.model.ReceiptRuleSetMetadata = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ReceiptRuleSetMetadata(")
        append("createdTimestamp=$createdTimestamp,")
        append("name=$name")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = createdTimestamp?.hashCode() ?: 0
        result = 31 * result + (name?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ReceiptRuleSetMetadata

        if (createdTimestamp != other.createdTimestamp) return false
        if (name != other.name) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ses.model.ReceiptRuleSetMetadata = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The date and time the receipt rule set was created.
         */
        public var createdTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the receipt rule set. The name must meet the following requirements:
         * + Contain only ASCII letters (a-z, A-Z), numbers (0-9), underscores (_), or dashes (-).
         * + Start and end with a letter or number.
         * + Contain 64 characters or fewer.
         */
        public var name: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ses.model.ReceiptRuleSetMetadata) : this() {
            this.createdTimestamp = x.createdTimestamp
            this.name = x.name
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ses.model.ReceiptRuleSetMetadata = ReceiptRuleSetMetadata(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
