// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ses.model



/**
 * Receipt rules enable you to specify which actions Amazon SES should take when it receives mail on behalf of one or more email addresses or domains that you own.
 *
 * Each receipt rule defines a set of email addresses or domains that it applies to. If the email addresses or domains match at least one recipient address of the message, Amazon SES executes all of the receipt rule's actions on the message.
 *
 * For information about setting up receipt rules, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/receiving-email-receipt-rules-console-walkthrough.html).
 */
public class ReceiptRule private constructor(builder: Builder) {
    /**
     * An ordered list of actions to perform on messages that match at least one of the recipient email addresses or domains specified in the receipt rule.
     */
    public val actions: List<ReceiptAction>? = builder.actions
    /**
     * If `true`, the receipt rule is active. The default value is `false`.
     */
    public val enabled: kotlin.Boolean = builder.enabled
    /**
     * The name of the receipt rule. The name must meet the following requirements:
     * + Contain only ASCII letters (a-z, A-Z), numbers (0-9), underscores (_), dashes (-), or periods (.).
     * + Start and end with a letter or number.
     * + Contain 64 characters or fewer.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The recipient domains and email addresses that the receipt rule applies to. If this field is not specified, this rule matches all recipients on all verified domains.
     */
    public val recipients: List<String>? = builder.recipients
    /**
     * If `true`, then messages that this receipt rule applies to are scanned for spam and viruses. The default value is `false`.
     */
    public val scanEnabled: kotlin.Boolean = builder.scanEnabled
    /**
     * Specifies whether Amazon SES should require that incoming email is delivered over a connection encrypted with Transport Layer Security (TLS). If this parameter is set to `Require`, Amazon SES bounces emails that are not received over TLS. The default is `Optional`.
     */
    public val tlsPolicy: aws.sdk.kotlin.services.ses.model.TlsPolicy? = builder.tlsPolicy

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ses.model.ReceiptRule = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ReceiptRule(")
        append("actions=$actions,")
        append("enabled=$enabled,")
        append("name=$name,")
        append("recipients=$recipients,")
        append("scanEnabled=$scanEnabled,")
        append("tlsPolicy=$tlsPolicy")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = actions?.hashCode() ?: 0
        result = 31 * result + (enabled.hashCode())
        result = 31 * result + (name.hashCode())
        result = 31 * result + (recipients?.hashCode() ?: 0)
        result = 31 * result + (scanEnabled.hashCode())
        result = 31 * result + (tlsPolicy?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ReceiptRule

        if (actions != other.actions) return false
        if (enabled != other.enabled) return false
        if (name != other.name) return false
        if (recipients != other.recipients) return false
        if (scanEnabled != other.scanEnabled) return false
        if (tlsPolicy != other.tlsPolicy) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ses.model.ReceiptRule = Builder(this).apply(block).build()

    public class Builder {
        /**
         * An ordered list of actions to perform on messages that match at least one of the recipient email addresses or domains specified in the receipt rule.
         */
        public var actions: List<ReceiptAction>? = null
        /**
         * If `true`, the receipt rule is active. The default value is `false`.
         */
        public var enabled: kotlin.Boolean = false
        /**
         * The name of the receipt rule. The name must meet the following requirements:
         * + Contain only ASCII letters (a-z, A-Z), numbers (0-9), underscores (_), dashes (-), or periods (.).
         * + Start and end with a letter or number.
         * + Contain 64 characters or fewer.
         */
        public var name: kotlin.String? = null
        /**
         * The recipient domains and email addresses that the receipt rule applies to. If this field is not specified, this rule matches all recipients on all verified domains.
         */
        public var recipients: List<String>? = null
        /**
         * If `true`, then messages that this receipt rule applies to are scanned for spam and viruses. The default value is `false`.
         */
        public var scanEnabled: kotlin.Boolean = false
        /**
         * Specifies whether Amazon SES should require that incoming email is delivered over a connection encrypted with Transport Layer Security (TLS). If this parameter is set to `Require`, Amazon SES bounces emails that are not received over TLS. The default is `Optional`.
         */
        public var tlsPolicy: aws.sdk.kotlin.services.ses.model.TlsPolicy? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ses.model.ReceiptRule) : this() {
            this.actions = x.actions
            this.enabled = x.enabled
            this.name = x.name
            this.recipients = x.recipients
            this.scanEnabled = x.scanEnabled
            this.tlsPolicy = x.tlsPolicy
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ses.model.ReceiptRule = ReceiptRule(this)

        internal fun correctErrors(): Builder {
            if (name == null) name = ""
            return this
        }
    }
}
