// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ses.model



/**
 * A receipt IP address filter enables you to specify whether to accept or reject mail originating from an IP address or range of IP addresses.
 *
 * For information about setting up IP address filters, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/receiving-email-ip-filtering-console-walkthrough.html).
 */
public class ReceiptFilter private constructor(builder: Builder) {
    /**
     * A structure that provides the IP addresses to block or allow, and whether to block or allow incoming mail from them.
     */
    public val ipFilter: aws.sdk.kotlin.services.ses.model.ReceiptIpFilter? = builder.ipFilter
    /**
     * The name of the IP address filter. The name must meet the following requirements:
     * + Contain only ASCII letters (a-z, A-Z), numbers (0-9), underscores (_), or dashes (-).
     * + Start and end with a letter or number.
     * + Contain 64 characters or fewer.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ses.model.ReceiptFilter = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ReceiptFilter(")
        append("ipFilter=$ipFilter,")
        append("name=$name")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = ipFilter?.hashCode() ?: 0
        result = 31 * result + (name.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ReceiptFilter

        if (ipFilter != other.ipFilter) return false
        if (name != other.name) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ses.model.ReceiptFilter = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A structure that provides the IP addresses to block or allow, and whether to block or allow incoming mail from them.
         */
        public var ipFilter: aws.sdk.kotlin.services.ses.model.ReceiptIpFilter? = null
        /**
         * The name of the IP address filter. The name must meet the following requirements:
         * + Contain only ASCII letters (a-z, A-Z), numbers (0-9), underscores (_), or dashes (-).
         * + Start and end with a letter or number.
         * + Contain 64 characters or fewer.
         */
        public var name: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ses.model.ReceiptFilter) : this() {
            this.ipFilter = x.ipFilter
            this.name = x.name
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ses.model.ReceiptFilter = ReceiptFilter(this)

        /**
         * construct an [aws.sdk.kotlin.services.ses.model.ReceiptIpFilter] inside the given [block]
         */
        public fun ipFilter(block: aws.sdk.kotlin.services.ses.model.ReceiptIpFilter.Builder.() -> kotlin.Unit) {
            this.ipFilter = aws.sdk.kotlin.services.ses.model.ReceiptIpFilter.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (name == null) name = ""
            return this
        }
    }
}
