// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ses.model



/**
 * An action that Amazon SES can take when it receives an email on behalf of one or more email addresses or domains that you own. An instance of this data type can represent only one action.
 *
 * For information about setting up receipt rules, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/receiving-email-receipt-rules-console-walkthrough.html).
 */
public class ReceiptAction private constructor(builder: Builder) {
    /**
     * Adds a header to the received email.
     */
    public val addHeaderAction: aws.sdk.kotlin.services.ses.model.AddHeaderAction? = builder.addHeaderAction
    /**
     * Rejects the received email by returning a bounce response to the sender and, optionally, publishes a notification to Amazon Simple Notification Service (Amazon SNS).
     */
    public val bounceAction: aws.sdk.kotlin.services.ses.model.BounceAction? = builder.bounceAction
    /**
     * Calls an Amazon Web Services Lambda function, and optionally, publishes a notification to Amazon SNS.
     */
    public val lambdaAction: aws.sdk.kotlin.services.ses.model.LambdaAction? = builder.lambdaAction
    /**
     * Saves the received message to an Amazon Simple Storage Service (Amazon S3) bucket and, optionally, publishes a notification to Amazon SNS.
     */
    public val s3Action: aws.sdk.kotlin.services.ses.model.S3Action? = builder.s3Action
    /**
     * Publishes the email content within a notification to Amazon SNS.
     */
    public val snsAction: aws.sdk.kotlin.services.ses.model.SnsAction? = builder.snsAction
    /**
     * Terminates the evaluation of the receipt rule set and optionally publishes a notification to Amazon SNS.
     */
    public val stopAction: aws.sdk.kotlin.services.ses.model.StopAction? = builder.stopAction
    /**
     * Calls Amazon WorkMail and, optionally, publishes a notification to Amazon Amazon SNS.
     */
    public val workmailAction: aws.sdk.kotlin.services.ses.model.WorkmailAction? = builder.workmailAction

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ses.model.ReceiptAction = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ReceiptAction(")
        append("addHeaderAction=$addHeaderAction,")
        append("bounceAction=$bounceAction,")
        append("lambdaAction=$lambdaAction,")
        append("s3Action=$s3Action,")
        append("snsAction=$snsAction,")
        append("stopAction=$stopAction,")
        append("workmailAction=$workmailAction")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = addHeaderAction?.hashCode() ?: 0
        result = 31 * result + (bounceAction?.hashCode() ?: 0)
        result = 31 * result + (lambdaAction?.hashCode() ?: 0)
        result = 31 * result + (s3Action?.hashCode() ?: 0)
        result = 31 * result + (snsAction?.hashCode() ?: 0)
        result = 31 * result + (stopAction?.hashCode() ?: 0)
        result = 31 * result + (workmailAction?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ReceiptAction

        if (addHeaderAction != other.addHeaderAction) return false
        if (bounceAction != other.bounceAction) return false
        if (lambdaAction != other.lambdaAction) return false
        if (s3Action != other.s3Action) return false
        if (snsAction != other.snsAction) return false
        if (stopAction != other.stopAction) return false
        if (workmailAction != other.workmailAction) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ses.model.ReceiptAction = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Adds a header to the received email.
         */
        public var addHeaderAction: aws.sdk.kotlin.services.ses.model.AddHeaderAction? = null
        /**
         * Rejects the received email by returning a bounce response to the sender and, optionally, publishes a notification to Amazon Simple Notification Service (Amazon SNS).
         */
        public var bounceAction: aws.sdk.kotlin.services.ses.model.BounceAction? = null
        /**
         * Calls an Amazon Web Services Lambda function, and optionally, publishes a notification to Amazon SNS.
         */
        public var lambdaAction: aws.sdk.kotlin.services.ses.model.LambdaAction? = null
        /**
         * Saves the received message to an Amazon Simple Storage Service (Amazon S3) bucket and, optionally, publishes a notification to Amazon SNS.
         */
        public var s3Action: aws.sdk.kotlin.services.ses.model.S3Action? = null
        /**
         * Publishes the email content within a notification to Amazon SNS.
         */
        public var snsAction: aws.sdk.kotlin.services.ses.model.SnsAction? = null
        /**
         * Terminates the evaluation of the receipt rule set and optionally publishes a notification to Amazon SNS.
         */
        public var stopAction: aws.sdk.kotlin.services.ses.model.StopAction? = null
        /**
         * Calls Amazon WorkMail and, optionally, publishes a notification to Amazon Amazon SNS.
         */
        public var workmailAction: aws.sdk.kotlin.services.ses.model.WorkmailAction? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ses.model.ReceiptAction) : this() {
            this.addHeaderAction = x.addHeaderAction
            this.bounceAction = x.bounceAction
            this.lambdaAction = x.lambdaAction
            this.s3Action = x.s3Action
            this.snsAction = x.snsAction
            this.stopAction = x.stopAction
            this.workmailAction = x.workmailAction
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ses.model.ReceiptAction = ReceiptAction(this)

        /**
         * construct an [aws.sdk.kotlin.services.ses.model.AddHeaderAction] inside the given [block]
         */
        public fun addHeaderAction(block: aws.sdk.kotlin.services.ses.model.AddHeaderAction.Builder.() -> kotlin.Unit) {
            this.addHeaderAction = aws.sdk.kotlin.services.ses.model.AddHeaderAction.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ses.model.BounceAction] inside the given [block]
         */
        public fun bounceAction(block: aws.sdk.kotlin.services.ses.model.BounceAction.Builder.() -> kotlin.Unit) {
            this.bounceAction = aws.sdk.kotlin.services.ses.model.BounceAction.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ses.model.LambdaAction] inside the given [block]
         */
        public fun lambdaAction(block: aws.sdk.kotlin.services.ses.model.LambdaAction.Builder.() -> kotlin.Unit) {
            this.lambdaAction = aws.sdk.kotlin.services.ses.model.LambdaAction.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ses.model.S3Action] inside the given [block]
         */
        public fun s3Action(block: aws.sdk.kotlin.services.ses.model.S3Action.Builder.() -> kotlin.Unit) {
            this.s3Action = aws.sdk.kotlin.services.ses.model.S3Action.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ses.model.SnsAction] inside the given [block]
         */
        public fun snsAction(block: aws.sdk.kotlin.services.ses.model.SnsAction.Builder.() -> kotlin.Unit) {
            this.snsAction = aws.sdk.kotlin.services.ses.model.SnsAction.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ses.model.StopAction] inside the given [block]
         */
        public fun stopAction(block: aws.sdk.kotlin.services.ses.model.StopAction.Builder.() -> kotlin.Unit) {
            this.stopAction = aws.sdk.kotlin.services.ses.model.StopAction.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ses.model.WorkmailAction] inside the given [block]
         */
        public fun workmailAction(block: aws.sdk.kotlin.services.ses.model.WorkmailAction.Builder.() -> kotlin.Unit) {
            this.workmailAction = aws.sdk.kotlin.services.ses.model.WorkmailAction.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
