// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ses.model



/**
 * Contains the name and value of a tag that you can provide to `SendEmail` or `SendRawEmail` to apply to an email.
 *
 * Message tags, which you use with configuration sets, enable you to publish email sending events. For information about using configuration sets, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/monitor-sending-activity.html).
 */
public class MessageTag private constructor(builder: Builder) {
    /**
     * The name of the tag. The name must meet the following requirements:
     * + Contain only ASCII letters (a-z, A-Z), numbers (0-9), underscores (_), or dashes (-).
     * + Contain 256 characters or fewer.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The value of the tag. The value must meet the following requirements:
     * + Contain only ASCII letters (a-z, A-Z), numbers (0-9), underscores (_), or dashes (-).
     * + Contain 256 characters or fewer.
     */
    public val value: kotlin.String = requireNotNull(builder.value) { "A non-null value must be provided for value" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ses.model.MessageTag = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MessageTag(")
        append("name=$name,")
        append("value=$value")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = name.hashCode()
        result = 31 * result + (value.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MessageTag

        if (name != other.name) return false
        if (value != other.value) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ses.model.MessageTag = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the tag. The name must meet the following requirements:
         * + Contain only ASCII letters (a-z, A-Z), numbers (0-9), underscores (_), or dashes (-).
         * + Contain 256 characters or fewer.
         */
        public var name: kotlin.String? = null
        /**
         * The value of the tag. The value must meet the following requirements:
         * + Contain only ASCII letters (a-z, A-Z), numbers (0-9), underscores (_), or dashes (-).
         * + Contain 256 characters or fewer.
         */
        public var value: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ses.model.MessageTag) : this() {
            this.name = x.name
            this.value = x.value
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ses.model.MessageTag = MessageTag(this)

        internal fun correctErrors(): Builder {
            if (name == null) name = ""
            if (value == null) value = ""
            return this
        }
    }
}
