// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ses.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Message-related information to include in the Delivery Status Notification (DSN) when an email that Amazon SES receives on your behalf bounces.
 *
 * For information about receiving email through Amazon SES, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/receiving-email.html).
 */
public class MessageDsn private constructor(builder: Builder) {
    /**
     * When the message was received by the reporting mail transfer agent (MTA), in [RFC 822](https://www.ietf.org/rfc/rfc0822.txt) date-time format.
     */
    public val arrivalDate: aws.smithy.kotlin.runtime.time.Instant? = builder.arrivalDate
    /**
     * Additional X-headers to include in the DSN.
     */
    public val extensionFields: List<ExtensionField>? = builder.extensionFields
    /**
     * The reporting MTA that attempted to deliver the message, formatted as specified in [RFC 3464](https://tools.ietf.org/html/rfc3464) (`mta-name-type; mta-name`). The default value is `dns; inbound-smtp.[region].amazonaws.com`.
     */
    public val reportingMta: kotlin.String = requireNotNull(builder.reportingMta) { "A non-null value must be provided for reportingMta" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ses.model.MessageDsn = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MessageDsn(")
        append("arrivalDate=$arrivalDate,")
        append("extensionFields=$extensionFields,")
        append("reportingMta=$reportingMta")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arrivalDate?.hashCode() ?: 0
        result = 31 * result + (extensionFields?.hashCode() ?: 0)
        result = 31 * result + (reportingMta.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MessageDsn

        if (arrivalDate != other.arrivalDate) return false
        if (extensionFields != other.extensionFields) return false
        if (reportingMta != other.reportingMta) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ses.model.MessageDsn = Builder(this).apply(block).build()

    public class Builder {
        /**
         * When the message was received by the reporting mail transfer agent (MTA), in [RFC 822](https://www.ietf.org/rfc/rfc0822.txt) date-time format.
         */
        public var arrivalDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Additional X-headers to include in the DSN.
         */
        public var extensionFields: List<ExtensionField>? = null
        /**
         * The reporting MTA that attempted to deliver the message, formatted as specified in [RFC 3464](https://tools.ietf.org/html/rfc3464) (`mta-name-type; mta-name`). The default value is `dns; inbound-smtp.[region].amazonaws.com`.
         */
        public var reportingMta: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ses.model.MessageDsn) : this() {
            this.arrivalDate = x.arrivalDate
            this.extensionFields = x.extensionFields
            this.reportingMta = x.reportingMta
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ses.model.MessageDsn = MessageDsn(this)

        internal fun correctErrors(): Builder {
            if (reportingMta == null) reportingMta = ""
            return this
        }
    }
}
