// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ses.model



/**
 * Represents a request to list the existing custom verification email templates for your account.
 *
 * For more information about custom verification email templates, see [Using Custom Verification Email Templates](https://docs.aws.amazon.com/ses/latest/dg/creating-identities.html#send-email-verify-address-custom) in the *Amazon SES Developer Guide*.
 */
public class ListCustomVerificationEmailTemplatesRequest private constructor(builder: Builder) {
    /**
     * The maximum number of custom verification email templates to return. This value must be at least 1 and less than or equal to 50. If you do not specify a value, or if you specify a value less than 1 or greater than 50, the operation returns up to 50 results.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * An array the contains the name and creation time stamp for each template in your Amazon SES account.
     */
    public val nextToken: kotlin.String? = builder.nextToken

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ses.model.ListCustomVerificationEmailTemplatesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListCustomVerificationEmailTemplatesRequest(")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = maxResults ?: 0
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListCustomVerificationEmailTemplatesRequest

        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ses.model.ListCustomVerificationEmailTemplatesRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The maximum number of custom verification email templates to return. This value must be at least 1 and less than or equal to 50. If you do not specify a value, or if you specify a value less than 1 or greater than 50, the operation returns up to 50 results.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * An array the contains the name and creation time stamp for each template in your Amazon SES account.
         */
        public var nextToken: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ses.model.ListCustomVerificationEmailTemplatesRequest) : this() {
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ses.model.ListCustomVerificationEmailTemplatesRequest = ListCustomVerificationEmailTemplatesRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
