// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ses.model



/**
 * Represents a request to list the configuration sets associated with your Amazon Web Services account. Configuration sets enable you to publish email sending events. For information about using configuration sets, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/monitor-sending-activity.html).
 */
public class ListConfigurationSetsRequest private constructor(builder: Builder) {
    /**
     * The number of configuration sets to return.
     */
    public val maxItems: kotlin.Int? = builder.maxItems
    /**
     * A token returned from a previous call to `ListConfigurationSets` to indicate the position of the configuration set in the configuration set list.
     */
    public val nextToken: kotlin.String? = builder.nextToken

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ses.model.ListConfigurationSetsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListConfigurationSetsRequest(")
        append("maxItems=$maxItems,")
        append("nextToken=$nextToken")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = maxItems ?: 0
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListConfigurationSetsRequest

        if (maxItems != other.maxItems) return false
        if (nextToken != other.nextToken) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ses.model.ListConfigurationSetsRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The number of configuration sets to return.
         */
        public var maxItems: kotlin.Int? = null
        /**
         * A token returned from a previous call to `ListConfigurationSets` to indicate the position of the configuration set in the configuration set list.
         */
        public var nextToken: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ses.model.ListConfigurationSetsRequest) : this() {
            this.maxItems = x.maxItems
            this.nextToken = x.nextToken
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ses.model.ListConfigurationSetsRequest = ListConfigurationSetsRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
