// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ses.model



/**
 * Contains the delivery stream ARN and the IAM role ARN associated with an Amazon Kinesis Firehose event destination.
 *
 * Event destinations, such as Amazon Kinesis Firehose, are associated with configuration sets, which enable you to publish email sending events. For information about using configuration sets, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/monitor-sending-activity.html).
 */
public class KinesisFirehoseDestination private constructor(builder: Builder) {
    /**
     * The ARN of the Amazon Kinesis Firehose stream that email sending events should be published to.
     */
    public val deliveryStreamArn: kotlin.String = requireNotNull(builder.deliveryStreamArn) { "A non-null value must be provided for deliveryStreamArn" }
    /**
     * The ARN of the IAM role under which Amazon SES publishes email sending events to the Amazon Kinesis Firehose stream.
     */
    public val iamRoleArn: kotlin.String = requireNotNull(builder.iamRoleArn) { "A non-null value must be provided for iamRoleArn" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ses.model.KinesisFirehoseDestination = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("KinesisFirehoseDestination(")
        append("deliveryStreamArn=$deliveryStreamArn,")
        append("iamRoleArn=$iamRoleArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = deliveryStreamArn.hashCode()
        result = 31 * result + (iamRoleArn.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as KinesisFirehoseDestination

        if (deliveryStreamArn != other.deliveryStreamArn) return false
        if (iamRoleArn != other.iamRoleArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ses.model.KinesisFirehoseDestination = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ARN of the Amazon Kinesis Firehose stream that email sending events should be published to.
         */
        public var deliveryStreamArn: kotlin.String? = null
        /**
         * The ARN of the IAM role under which Amazon SES publishes email sending events to the Amazon Kinesis Firehose stream.
         */
        public var iamRoleArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ses.model.KinesisFirehoseDestination) : this() {
            this.deliveryStreamArn = x.deliveryStreamArn
            this.iamRoleArn = x.iamRoleArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ses.model.KinesisFirehoseDestination = KinesisFirehoseDestination(this)

        internal fun correctErrors(): Builder {
            if (deliveryStreamArn == null) deliveryStreamArn = ""
            if (iamRoleArn == null) iamRoleArn = ""
            return this
        }
    }
}
