// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ses.model

import aws.smithy.kotlin.runtime.ServiceErrorMetadata

/**
 * Indicates that the provided Amazon S3 bucket or Amazon Web Services KMS encryption key is invalid, or that Amazon SES could not publish to the bucket, possibly due to permissions issues. For information about giving permissions, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-permissions.html).
 */
public class InvalidS3ConfigurationException private constructor(builder: Builder) : SesException() {

    /**
     * Indicated that the S3 Bucket was not found.
     */
    public val bucket: kotlin.String? = builder.bucket
    override val message: kotlin.String? = builder.message

    init {
        sdkErrorMetadata.attributes[ServiceErrorMetadata.ErrorType] = ErrorType.Client
    }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ses.model.InvalidS3ConfigurationException = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InvalidS3ConfigurationException(")
        append("bucket=$bucket,")
        append("message=$message")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = bucket?.hashCode() ?: 0
        result = 31 * result + (message?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InvalidS3ConfigurationException

        if (bucket != other.bucket) return false
        if (message != other.message) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ses.model.InvalidS3ConfigurationException = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Indicated that the S3 Bucket was not found.
         */
        public var bucket: kotlin.String? = null
        public var message: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ses.model.InvalidS3ConfigurationException) : this() {
            this.bucket = x.bucket
            this.message = x.message
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ses.model.InvalidS3ConfigurationException = InvalidS3ConfigurationException(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
