// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ses.model



/**
 * Represents the notification attributes of an identity, including whether an identity has Amazon Simple Notification Service (Amazon SNS) topics set for bounce, complaint, and/or delivery notifications, and whether feedback forwarding is enabled for bounce and complaint notifications.
 */
public class IdentityNotificationAttributes private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the Amazon SNS topic where Amazon SES publishes bounce notifications.
     */
    public val bounceTopic: kotlin.String = requireNotNull(builder.bounceTopic) { "A non-null value must be provided for bounceTopic" }
    /**
     * The Amazon Resource Name (ARN) of the Amazon SNS topic where Amazon SES publishes complaint notifications.
     */
    public val complaintTopic: kotlin.String = requireNotNull(builder.complaintTopic) { "A non-null value must be provided for complaintTopic" }
    /**
     * The Amazon Resource Name (ARN) of the Amazon SNS topic where Amazon SES publishes delivery notifications.
     */
    public val deliveryTopic: kotlin.String = requireNotNull(builder.deliveryTopic) { "A non-null value must be provided for deliveryTopic" }
    /**
     * Describes whether Amazon SES forwards bounce and complaint notifications as email. `true` indicates that Amazon SES forwards bounce and complaint notifications as email, while `false` indicates that bounce and complaint notifications are published only to the specified bounce and complaint Amazon SNS topics.
     */
    public val forwardingEnabled: kotlin.Boolean = builder.forwardingEnabled
    /**
     * Describes whether Amazon SES includes the original email headers in Amazon SNS notifications of type `Bounce`. A value of `true` specifies that Amazon SES includes headers in bounce notifications, and a value of `false` specifies that Amazon SES does not include headers in bounce notifications.
     */
    public val headersInBounceNotificationsEnabled: kotlin.Boolean = builder.headersInBounceNotificationsEnabled
    /**
     * Describes whether Amazon SES includes the original email headers in Amazon SNS notifications of type `Complaint`. A value of `true` specifies that Amazon SES includes headers in complaint notifications, and a value of `false` specifies that Amazon SES does not include headers in complaint notifications.
     */
    public val headersInComplaintNotificationsEnabled: kotlin.Boolean = builder.headersInComplaintNotificationsEnabled
    /**
     * Describes whether Amazon SES includes the original email headers in Amazon SNS notifications of type `Delivery`. A value of `true` specifies that Amazon SES includes headers in delivery notifications, and a value of `false` specifies that Amazon SES does not include headers in delivery notifications.
     */
    public val headersInDeliveryNotificationsEnabled: kotlin.Boolean = builder.headersInDeliveryNotificationsEnabled

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ses.model.IdentityNotificationAttributes = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("IdentityNotificationAttributes(")
        append("bounceTopic=$bounceTopic,")
        append("complaintTopic=$complaintTopic,")
        append("deliveryTopic=$deliveryTopic,")
        append("forwardingEnabled=$forwardingEnabled,")
        append("headersInBounceNotificationsEnabled=$headersInBounceNotificationsEnabled,")
        append("headersInComplaintNotificationsEnabled=$headersInComplaintNotificationsEnabled,")
        append("headersInDeliveryNotificationsEnabled=$headersInDeliveryNotificationsEnabled")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = bounceTopic.hashCode()
        result = 31 * result + (complaintTopic.hashCode())
        result = 31 * result + (deliveryTopic.hashCode())
        result = 31 * result + (forwardingEnabled.hashCode())
        result = 31 * result + (headersInBounceNotificationsEnabled.hashCode())
        result = 31 * result + (headersInComplaintNotificationsEnabled.hashCode())
        result = 31 * result + (headersInDeliveryNotificationsEnabled.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as IdentityNotificationAttributes

        if (bounceTopic != other.bounceTopic) return false
        if (complaintTopic != other.complaintTopic) return false
        if (deliveryTopic != other.deliveryTopic) return false
        if (forwardingEnabled != other.forwardingEnabled) return false
        if (headersInBounceNotificationsEnabled != other.headersInBounceNotificationsEnabled) return false
        if (headersInComplaintNotificationsEnabled != other.headersInComplaintNotificationsEnabled) return false
        if (headersInDeliveryNotificationsEnabled != other.headersInDeliveryNotificationsEnabled) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ses.model.IdentityNotificationAttributes = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the Amazon SNS topic where Amazon SES publishes bounce notifications.
         */
        public var bounceTopic: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the Amazon SNS topic where Amazon SES publishes complaint notifications.
         */
        public var complaintTopic: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the Amazon SNS topic where Amazon SES publishes delivery notifications.
         */
        public var deliveryTopic: kotlin.String? = null
        /**
         * Describes whether Amazon SES forwards bounce and complaint notifications as email. `true` indicates that Amazon SES forwards bounce and complaint notifications as email, while `false` indicates that bounce and complaint notifications are published only to the specified bounce and complaint Amazon SNS topics.
         */
        public var forwardingEnabled: kotlin.Boolean = false
        /**
         * Describes whether Amazon SES includes the original email headers in Amazon SNS notifications of type `Bounce`. A value of `true` specifies that Amazon SES includes headers in bounce notifications, and a value of `false` specifies that Amazon SES does not include headers in bounce notifications.
         */
        public var headersInBounceNotificationsEnabled: kotlin.Boolean = false
        /**
         * Describes whether Amazon SES includes the original email headers in Amazon SNS notifications of type `Complaint`. A value of `true` specifies that Amazon SES includes headers in complaint notifications, and a value of `false` specifies that Amazon SES does not include headers in complaint notifications.
         */
        public var headersInComplaintNotificationsEnabled: kotlin.Boolean = false
        /**
         * Describes whether Amazon SES includes the original email headers in Amazon SNS notifications of type `Delivery`. A value of `true` specifies that Amazon SES includes headers in delivery notifications, and a value of `false` specifies that Amazon SES does not include headers in delivery notifications.
         */
        public var headersInDeliveryNotificationsEnabled: kotlin.Boolean = false

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ses.model.IdentityNotificationAttributes) : this() {
            this.bounceTopic = x.bounceTopic
            this.complaintTopic = x.complaintTopic
            this.deliveryTopic = x.deliveryTopic
            this.forwardingEnabled = x.forwardingEnabled
            this.headersInBounceNotificationsEnabled = x.headersInBounceNotificationsEnabled
            this.headersInComplaintNotificationsEnabled = x.headersInComplaintNotificationsEnabled
            this.headersInDeliveryNotificationsEnabled = x.headersInDeliveryNotificationsEnabled
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ses.model.IdentityNotificationAttributes = IdentityNotificationAttributes(this)

        internal fun correctErrors(): Builder {
            if (bounceTopic == null) bounceTopic = ""
            if (complaintTopic == null) complaintTopic = ""
            if (deliveryTopic == null) deliveryTopic = ""
            return this
        }
    }
}
