// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ses.model



/**
 * Represents the custom MAIL FROM domain attributes of a verified identity (email address or domain).
 */
public class IdentityMailFromDomainAttributes private constructor(builder: Builder) {
    /**
     * The action that Amazon SES takes if it cannot successfully read the required MX record when you send an email. A value of `UseDefaultValue` indicates that if Amazon SES cannot read the required MX record, it uses amazonses.com (or a subdomain of that) as the MAIL FROM domain. A value of `RejectMessage` indicates that if Amazon SES cannot read the required MX record, Amazon SES returns a `MailFromDomainNotVerified` error and does not send the email.
     *
     * The custom MAIL FROM setup states that result in this behavior are `Pending`, `Failed`, and `TemporaryFailure`.
     */
    public val behaviorOnMxFailure: aws.sdk.kotlin.services.ses.model.BehaviorOnMxFailure = requireNotNull(builder.behaviorOnMxFailure) { "A non-null value must be provided for behaviorOnMxFailure" }
    /**
     * The custom MAIL FROM domain that the identity is configured to use.
     */
    public val mailFromDomain: kotlin.String = requireNotNull(builder.mailFromDomain) { "A non-null value must be provided for mailFromDomain" }
    /**
     * The state that indicates whether Amazon SES has successfully read the MX record required for custom MAIL FROM domain setup. If the state is `Success`, Amazon SES uses the specified custom MAIL FROM domain when the verified identity sends an email. All other states indicate that Amazon SES takes the action described by `BehaviorOnMXFailure`.
     */
    public val mailFromDomainStatus: aws.sdk.kotlin.services.ses.model.CustomMailFromStatus = requireNotNull(builder.mailFromDomainStatus) { "A non-null value must be provided for mailFromDomainStatus" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ses.model.IdentityMailFromDomainAttributes = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("IdentityMailFromDomainAttributes(")
        append("behaviorOnMxFailure=$behaviorOnMxFailure,")
        append("mailFromDomain=$mailFromDomain,")
        append("mailFromDomainStatus=$mailFromDomainStatus")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = behaviorOnMxFailure.hashCode()
        result = 31 * result + (mailFromDomain.hashCode())
        result = 31 * result + (mailFromDomainStatus.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as IdentityMailFromDomainAttributes

        if (behaviorOnMxFailure != other.behaviorOnMxFailure) return false
        if (mailFromDomain != other.mailFromDomain) return false
        if (mailFromDomainStatus != other.mailFromDomainStatus) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ses.model.IdentityMailFromDomainAttributes = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The action that Amazon SES takes if it cannot successfully read the required MX record when you send an email. A value of `UseDefaultValue` indicates that if Amazon SES cannot read the required MX record, it uses amazonses.com (or a subdomain of that) as the MAIL FROM domain. A value of `RejectMessage` indicates that if Amazon SES cannot read the required MX record, Amazon SES returns a `MailFromDomainNotVerified` error and does not send the email.
         *
         * The custom MAIL FROM setup states that result in this behavior are `Pending`, `Failed`, and `TemporaryFailure`.
         */
        public var behaviorOnMxFailure: aws.sdk.kotlin.services.ses.model.BehaviorOnMxFailure? = null
        /**
         * The custom MAIL FROM domain that the identity is configured to use.
         */
        public var mailFromDomain: kotlin.String? = null
        /**
         * The state that indicates whether Amazon SES has successfully read the MX record required for custom MAIL FROM domain setup. If the state is `Success`, Amazon SES uses the specified custom MAIL FROM domain when the verified identity sends an email. All other states indicate that Amazon SES takes the action described by `BehaviorOnMXFailure`.
         */
        public var mailFromDomainStatus: aws.sdk.kotlin.services.ses.model.CustomMailFromStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ses.model.IdentityMailFromDomainAttributes) : this() {
            this.behaviorOnMxFailure = x.behaviorOnMxFailure
            this.mailFromDomain = x.mailFromDomain
            this.mailFromDomainStatus = x.mailFromDomainStatus
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ses.model.IdentityMailFromDomainAttributes = IdentityMailFromDomainAttributes(this)

        internal fun correctErrors(): Builder {
            if (behaviorOnMxFailure == null) behaviorOnMxFailure = BehaviorOnMxFailure.SdkUnknown("no value provided")
            if (mailFromDomain == null) mailFromDomain = ""
            if (mailFromDomainStatus == null) mailFromDomainStatus = CustomMailFromStatus.SdkUnknown("no value provided")
            return this
        }
    }
}
