// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ses.model



/**
 * Represents your Amazon SES daily sending quota, maximum send rate, and the number of emails you have sent in the last 24 hours.
 */
public class GetSendQuotaResponse private constructor(builder: Builder) {
    /**
     * The maximum number of emails the user is allowed to send in a 24-hour interval. A value of -1 signifies an unlimited quota.
     */
    public val max24HourSend: kotlin.Double = builder.max24HourSend
    /**
     * The maximum number of emails that Amazon SES can accept from the user's account per second.
     *
     * The rate at which Amazon SES accepts the user's messages might be less than the maximum send rate.
     */
    public val maxSendRate: kotlin.Double = builder.maxSendRate
    /**
     * The number of emails sent during the previous 24 hours.
     */
    public val sentLast24Hours: kotlin.Double = builder.sentLast24Hours

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ses.model.GetSendQuotaResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetSendQuotaResponse(")
        append("max24HourSend=$max24HourSend,")
        append("maxSendRate=$maxSendRate,")
        append("sentLast24Hours=$sentLast24Hours")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = max24HourSend.hashCode()
        result = 31 * result + (maxSendRate.hashCode())
        result = 31 * result + (sentLast24Hours.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetSendQuotaResponse

        if (max24HourSend != other.max24HourSend) return false
        if (maxSendRate != other.maxSendRate) return false
        if (sentLast24Hours != other.sentLast24Hours) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ses.model.GetSendQuotaResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The maximum number of emails the user is allowed to send in a 24-hour interval. A value of -1 signifies an unlimited quota.
         */
        public var max24HourSend: kotlin.Double = 0.0
        /**
         * The maximum number of emails that Amazon SES can accept from the user's account per second.
         *
         * The rate at which Amazon SES accepts the user's messages might be less than the maximum send rate.
         */
        public var maxSendRate: kotlin.Double = 0.0
        /**
         * The number of emails sent during the previous 24 hours.
         */
        public var sentLast24Hours: kotlin.Double = 0.0

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ses.model.GetSendQuotaResponse) : this() {
            this.max24HourSend = x.max24HourSend
            this.maxSendRate = x.maxSendRate
            this.sentLast24Hours = x.sentLast24Hours
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ses.model.GetSendQuotaResponse = GetSendQuotaResponse(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
