// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ses.model



/**
 * Represents a request for the status of Amazon SES Easy DKIM signing for an identity. For domain identities, this request also returns the DKIM tokens that are required for Easy DKIM signing, and whether Amazon SES successfully verified that these tokens were published. For more information about Easy DKIM, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/send-email-authentication-dkim-easy.html).
 */
public class GetIdentityDkimAttributesRequest private constructor(builder: Builder) {
    /**
     * A list of one or more verified identities - email addresses, domains, or both.
     */
    public val identities: List<String>? = builder.identities

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ses.model.GetIdentityDkimAttributesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetIdentityDkimAttributesRequest(")
        append("identities=$identities")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = identities?.hashCode() ?: 0
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetIdentityDkimAttributesRequest

        if (identities != other.identities) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ses.model.GetIdentityDkimAttributesRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A list of one or more verified identities - email addresses, domains, or both.
         */
        public var identities: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ses.model.GetIdentityDkimAttributesRequest) : this() {
            this.identities = x.identities
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ses.model.GetIdentityDkimAttributesRequest = GetIdentityDkimAttributesRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
