// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ses.model



/**
 * Additional X-headers to include in the Delivery Status Notification (DSN) when an email that Amazon SES receives on your behalf bounces.
 *
 * For information about receiving email through Amazon SES, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/receiving-email.html).
 */
public class ExtensionField private constructor(builder: Builder) {
    /**
     * The name of the header to add. Must be between 1 and 50 characters, inclusive, and consist of alphanumeric (a-z, A-Z, 0-9) characters and dashes only.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The value of the header to add. Must contain 2048 characters or fewer, and must not contain newline characters ("\r" or "\n").
     */
    public val value: kotlin.String = requireNotNull(builder.value) { "A non-null value must be provided for value" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ses.model.ExtensionField = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ExtensionField(")
        append("name=$name,")
        append("value=$value")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = name.hashCode()
        result = 31 * result + (value.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ExtensionField

        if (name != other.name) return false
        if (value != other.value) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ses.model.ExtensionField = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the header to add. Must be between 1 and 50 characters, inclusive, and consist of alphanumeric (a-z, A-Z, 0-9) characters and dashes only.
         */
        public var name: kotlin.String? = null
        /**
         * The value of the header to add. Must contain 2048 characters or fewer, and must not contain newline characters ("\r" or "\n").
         */
        public var value: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ses.model.ExtensionField) : this() {
            this.name = x.name
            this.value = x.value
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ses.model.ExtensionField = ExtensionField(this)

        internal fun correctErrors(): Builder {
            if (name == null) name = ""
            if (value == null) value = ""
            return this
        }
    }
}
