// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ses.model



/**
 * Contains information about an event destination.
 *
 * When you create or update an event destination, you must provide one, and only one, destination. The destination can be Amazon CloudWatch, Amazon Kinesis Firehose or Amazon Simple Notification Service (Amazon SNS).
 *
 * Event destinations are associated with configuration sets, which enable you to publish email sending events to Amazon CloudWatch, Amazon Kinesis Firehose, or Amazon Simple Notification Service (Amazon SNS). For information about using configuration sets, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/monitor-sending-activity.html).
 */
public class EventDestination private constructor(builder: Builder) {
    /**
     * An object that contains the names, default values, and sources of the dimensions associated with an Amazon CloudWatch event destination.
     */
    public val cloudWatchDestination: aws.sdk.kotlin.services.ses.model.CloudWatchDestination? = builder.cloudWatchDestination
    /**
     * Sets whether Amazon SES publishes events to this destination when you send an email with the associated configuration set. Set to `true` to enable publishing to this destination; set to `false` to prevent publishing to this destination. The default value is `false`.
     */
    public val enabled: kotlin.Boolean = builder.enabled
    /**
     * An object that contains the delivery stream ARN and the IAM role ARN associated with an Amazon Kinesis Firehose event destination.
     */
    public val kinesisFirehoseDestination: aws.sdk.kotlin.services.ses.model.KinesisFirehoseDestination? = builder.kinesisFirehoseDestination
    /**
     * The type of email sending events to publish to the event destination.
     * + `send` - The call was successful and Amazon SES is attempting to deliver the email.
     * + `reject` - Amazon SES determined that the email contained a virus and rejected it.
     * + `bounce` - The recipient's mail server permanently rejected the email. This corresponds to a hard bounce.
     * + `complaint` - The recipient marked the email as spam.
     * + `delivery` - Amazon SES successfully delivered the email to the recipient's mail server.
     * + `open` - The recipient received the email and opened it in their email client.
     * + `click` - The recipient clicked one or more links in the email.
     * + `renderingFailure` - Amazon SES did not send the email because of a template rendering issue.
     */
    public val matchingEventTypes: List<EventType> = requireNotNull(builder.matchingEventTypes) { "A non-null value must be provided for matchingEventTypes" }
    /**
     * The name of the event destination. The name must meet the following requirements:
     * + Contain only ASCII letters (a-z, A-Z), numbers (0-9), underscores (_), or dashes (-).
     * + Contain 64 characters or fewer.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * An object that contains the topic ARN associated with an Amazon Simple Notification Service (Amazon SNS) event destination.
     */
    public val snsDestination: aws.sdk.kotlin.services.ses.model.SnsDestination? = builder.snsDestination

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ses.model.EventDestination = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EventDestination(")
        append("cloudWatchDestination=$cloudWatchDestination,")
        append("enabled=$enabled,")
        append("kinesisFirehoseDestination=$kinesisFirehoseDestination,")
        append("matchingEventTypes=$matchingEventTypes,")
        append("name=$name,")
        append("snsDestination=$snsDestination")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = cloudWatchDestination?.hashCode() ?: 0
        result = 31 * result + (enabled.hashCode())
        result = 31 * result + (kinesisFirehoseDestination?.hashCode() ?: 0)
        result = 31 * result + (matchingEventTypes.hashCode())
        result = 31 * result + (name.hashCode())
        result = 31 * result + (snsDestination?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EventDestination

        if (cloudWatchDestination != other.cloudWatchDestination) return false
        if (enabled != other.enabled) return false
        if (kinesisFirehoseDestination != other.kinesisFirehoseDestination) return false
        if (matchingEventTypes != other.matchingEventTypes) return false
        if (name != other.name) return false
        if (snsDestination != other.snsDestination) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ses.model.EventDestination = Builder(this).apply(block).build()

    public class Builder {
        /**
         * An object that contains the names, default values, and sources of the dimensions associated with an Amazon CloudWatch event destination.
         */
        public var cloudWatchDestination: aws.sdk.kotlin.services.ses.model.CloudWatchDestination? = null
        /**
         * Sets whether Amazon SES publishes events to this destination when you send an email with the associated configuration set. Set to `true` to enable publishing to this destination; set to `false` to prevent publishing to this destination. The default value is `false`.
         */
        public var enabled: kotlin.Boolean = false
        /**
         * An object that contains the delivery stream ARN and the IAM role ARN associated with an Amazon Kinesis Firehose event destination.
         */
        public var kinesisFirehoseDestination: aws.sdk.kotlin.services.ses.model.KinesisFirehoseDestination? = null
        /**
         * The type of email sending events to publish to the event destination.
         * + `send` - The call was successful and Amazon SES is attempting to deliver the email.
         * + `reject` - Amazon SES determined that the email contained a virus and rejected it.
         * + `bounce` - The recipient's mail server permanently rejected the email. This corresponds to a hard bounce.
         * + `complaint` - The recipient marked the email as spam.
         * + `delivery` - Amazon SES successfully delivered the email to the recipient's mail server.
         * + `open` - The recipient received the email and opened it in their email client.
         * + `click` - The recipient clicked one or more links in the email.
         * + `renderingFailure` - Amazon SES did not send the email because of a template rendering issue.
         */
        public var matchingEventTypes: List<EventType>? = null
        /**
         * The name of the event destination. The name must meet the following requirements:
         * + Contain only ASCII letters (a-z, A-Z), numbers (0-9), underscores (_), or dashes (-).
         * + Contain 64 characters or fewer.
         */
        public var name: kotlin.String? = null
        /**
         * An object that contains the topic ARN associated with an Amazon Simple Notification Service (Amazon SNS) event destination.
         */
        public var snsDestination: aws.sdk.kotlin.services.ses.model.SnsDestination? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ses.model.EventDestination) : this() {
            this.cloudWatchDestination = x.cloudWatchDestination
            this.enabled = x.enabled
            this.kinesisFirehoseDestination = x.kinesisFirehoseDestination
            this.matchingEventTypes = x.matchingEventTypes
            this.name = x.name
            this.snsDestination = x.snsDestination
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ses.model.EventDestination = EventDestination(this)

        /**
         * construct an [aws.sdk.kotlin.services.ses.model.CloudWatchDestination] inside the given [block]
         */
        public fun cloudWatchDestination(block: aws.sdk.kotlin.services.ses.model.CloudWatchDestination.Builder.() -> kotlin.Unit) {
            this.cloudWatchDestination = aws.sdk.kotlin.services.ses.model.CloudWatchDestination.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ses.model.KinesisFirehoseDestination] inside the given [block]
         */
        public fun kinesisFirehoseDestination(block: aws.sdk.kotlin.services.ses.model.KinesisFirehoseDestination.Builder.() -> kotlin.Unit) {
            this.kinesisFirehoseDestination = aws.sdk.kotlin.services.ses.model.KinesisFirehoseDestination.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ses.model.SnsDestination] inside the given [block]
         */
        public fun snsDestination(block: aws.sdk.kotlin.services.ses.model.SnsDestination.Builder.() -> kotlin.Unit) {
            this.snsDestination = aws.sdk.kotlin.services.ses.model.SnsDestination.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (matchingEventTypes == null) matchingEventTypes = emptyList()
            if (name == null) name = ""
            return this
        }
    }
}
