// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ses.model



/**
 * Represents a request to delete a sending authorization policy for an identity. Sending authorization is an Amazon SES feature that enables you to authorize other senders to use your identities. For information, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/sending-authorization.html).
 */
public class DeleteIdentityPolicyRequest private constructor(builder: Builder) {
    /**
     * The identity that is associated with the policy to delete. You can specify the identity by using its name or by using its Amazon Resource Name (ARN). Examples: `user@example.com`, `example.com`, `arn:aws:ses:us-east-1:123456789012:identity/example.com`.
     *
     * To successfully call this operation, you must own the identity.
     */
    public val identity: kotlin.String? = builder.identity
    /**
     * The name of the policy to be deleted.
     */
    public val policyName: kotlin.String? = builder.policyName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ses.model.DeleteIdentityPolicyRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DeleteIdentityPolicyRequest(")
        append("identity=$identity,")
        append("policyName=$policyName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = identity?.hashCode() ?: 0
        result = 31 * result + (policyName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DeleteIdentityPolicyRequest

        if (identity != other.identity) return false
        if (policyName != other.policyName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ses.model.DeleteIdentityPolicyRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The identity that is associated with the policy to delete. You can specify the identity by using its name or by using its Amazon Resource Name (ARN). Examples: `user@example.com`, `example.com`, `arn:aws:ses:us-east-1:123456789012:identity/example.com`.
         *
         * To successfully call this operation, you must own the identity.
         */
        public var identity: kotlin.String? = null
        /**
         * The name of the policy to be deleted.
         */
        public var policyName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ses.model.DeleteIdentityPolicyRequest) : this() {
            this.identity = x.identity
            this.policyName = x.policyName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ses.model.DeleteIdentityPolicyRequest = DeleteIdentityPolicyRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
