// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ses.model



/**
 * Represents a request to delete a configuration set event destination. Configuration set event destinations are associated with configuration sets, which enable you to publish email sending events. For information about using configuration sets, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/monitor-sending-activity.html).
 */
public class DeleteConfigurationSetEventDestinationRequest private constructor(builder: Builder) {
    /**
     * The name of the configuration set from which to delete the event destination.
     */
    public val configurationSetName: kotlin.String? = builder.configurationSetName
    /**
     * The name of the event destination to delete.
     */
    public val eventDestinationName: kotlin.String? = builder.eventDestinationName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ses.model.DeleteConfigurationSetEventDestinationRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DeleteConfigurationSetEventDestinationRequest(")
        append("configurationSetName=$configurationSetName,")
        append("eventDestinationName=$eventDestinationName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = configurationSetName?.hashCode() ?: 0
        result = 31 * result + (eventDestinationName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DeleteConfigurationSetEventDestinationRequest

        if (configurationSetName != other.configurationSetName) return false
        if (eventDestinationName != other.eventDestinationName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ses.model.DeleteConfigurationSetEventDestinationRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the configuration set from which to delete the event destination.
         */
        public var configurationSetName: kotlin.String? = null
        /**
         * The name of the event destination to delete.
         */
        public var eventDestinationName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ses.model.DeleteConfigurationSetEventDestinationRequest) : this() {
            this.configurationSetName = x.configurationSetName
            this.eventDestinationName = x.eventDestinationName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ses.model.DeleteConfigurationSetEventDestinationRequest = DeleteConfigurationSetEventDestinationRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
