// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ses.model



/**
 * Represents a request to create a receipt rule. You use receipt rules to receive email with Amazon SES. For more information, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/receiving-email-concepts.html).
 */
public class CreateReceiptRuleRequest private constructor(builder: Builder) {
    /**
     * The name of an existing rule after which the new rule is placed. If this parameter is null, the new rule is inserted at the beginning of the rule list.
     */
    public val after: kotlin.String? = builder.after
    /**
     * A data structure that contains the specified rule's name, actions, recipients, domains, enabled status, scan status, and TLS policy.
     */
    public val rule: aws.sdk.kotlin.services.ses.model.ReceiptRule? = builder.rule
    /**
     * The name of the rule set where the receipt rule is added.
     */
    public val ruleSetName: kotlin.String? = builder.ruleSetName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ses.model.CreateReceiptRuleRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateReceiptRuleRequest(")
        append("after=$after,")
        append("rule=$rule,")
        append("ruleSetName=$ruleSetName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = after?.hashCode() ?: 0
        result = 31 * result + (rule?.hashCode() ?: 0)
        result = 31 * result + (ruleSetName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateReceiptRuleRequest

        if (after != other.after) return false
        if (rule != other.rule) return false
        if (ruleSetName != other.ruleSetName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ses.model.CreateReceiptRuleRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of an existing rule after which the new rule is placed. If this parameter is null, the new rule is inserted at the beginning of the rule list.
         */
        public var after: kotlin.String? = null
        /**
         * A data structure that contains the specified rule's name, actions, recipients, domains, enabled status, scan status, and TLS policy.
         */
        public var rule: aws.sdk.kotlin.services.ses.model.ReceiptRule? = null
        /**
         * The name of the rule set where the receipt rule is added.
         */
        public var ruleSetName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ses.model.CreateReceiptRuleRequest) : this() {
            this.after = x.after
            this.rule = x.rule
            this.ruleSetName = x.ruleSetName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ses.model.CreateReceiptRuleRequest = CreateReceiptRuleRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.ses.model.ReceiptRule] inside the given [block]
         */
        public fun rule(block: aws.sdk.kotlin.services.ses.model.ReceiptRule.Builder.() -> kotlin.Unit) {
            this.rule = aws.sdk.kotlin.services.ses.model.ReceiptRule.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
