// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ses.model



/**
 * Represents a request to create a receipt rule set by cloning an existing one. You use receipt rule sets to receive email with Amazon SES. For more information, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/receiving-email-concepts.html).
 */
public class CloneReceiptRuleSetRequest private constructor(builder: Builder) {
    /**
     * The name of the rule set to clone.
     */
    public val originalRuleSetName: kotlin.String? = builder.originalRuleSetName
    /**
     * The name of the rule set to create. The name must meet the following requirements:
     * + Contain only ASCII letters (a-z, A-Z), numbers (0-9), underscores (_), or dashes (-).
     * + Start and end with a letter or number.
     * + Contain 64 characters or fewer.
     */
    public val ruleSetName: kotlin.String? = builder.ruleSetName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ses.model.CloneReceiptRuleSetRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CloneReceiptRuleSetRequest(")
        append("originalRuleSetName=$originalRuleSetName,")
        append("ruleSetName=$ruleSetName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = originalRuleSetName?.hashCode() ?: 0
        result = 31 * result + (ruleSetName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CloneReceiptRuleSetRequest

        if (originalRuleSetName != other.originalRuleSetName) return false
        if (ruleSetName != other.ruleSetName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ses.model.CloneReceiptRuleSetRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the rule set to clone.
         */
        public var originalRuleSetName: kotlin.String? = null
        /**
         * The name of the rule set to create. The name must meet the following requirements:
         * + Contain only ASCII letters (a-z, A-Z), numbers (0-9), underscores (_), or dashes (-).
         * + Start and end with a letter or number.
         * + Contain 64 characters or fewer.
         */
        public var ruleSetName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ses.model.CloneReceiptRuleSetRequest) : this() {
            this.originalRuleSetName = x.originalRuleSetName
            this.ruleSetName = x.ruleSetName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ses.model.CloneReceiptRuleSetRequest = CloneReceiptRuleSetRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
