// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ses.model



/**
 * Represents a request to update the tracking options for a configuration set.
 */
public class UpdateConfigurationSetTrackingOptionsRequest private constructor(builder: Builder) {
    /**
     * The name of the configuration set.
     */
    public val configurationSetName: kotlin.String? = builder.configurationSetName
    /**
     * A domain that is used to redirect email recipients to an Amazon SES-operated domain. This domain captures open and click events generated by Amazon SES emails.
     *
     * For more information, see [Configuring Custom Domains to Handle Open and Click Tracking](https://docs.aws.amazon.com/ses/latest/dg/configure-custom-open-click-domains.html) in the *Amazon SES Developer Guide*.
     */
    public val trackingOptions: aws.sdk.kotlin.services.ses.model.TrackingOptions? = builder.trackingOptions

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ses.model.UpdateConfigurationSetTrackingOptionsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateConfigurationSetTrackingOptionsRequest(")
        append("configurationSetName=$configurationSetName,")
        append("trackingOptions=$trackingOptions")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = configurationSetName?.hashCode() ?: 0
        result = 31 * result + (trackingOptions?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateConfigurationSetTrackingOptionsRequest

        if (configurationSetName != other.configurationSetName) return false
        if (trackingOptions != other.trackingOptions) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ses.model.UpdateConfigurationSetTrackingOptionsRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the configuration set.
         */
        public var configurationSetName: kotlin.String? = null
        /**
         * A domain that is used to redirect email recipients to an Amazon SES-operated domain. This domain captures open and click events generated by Amazon SES emails.
         *
         * For more information, see [Configuring Custom Domains to Handle Open and Click Tracking](https://docs.aws.amazon.com/ses/latest/dg/configure-custom-open-click-domains.html) in the *Amazon SES Developer Guide*.
         */
        public var trackingOptions: aws.sdk.kotlin.services.ses.model.TrackingOptions? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ses.model.UpdateConfigurationSetTrackingOptionsRequest) : this() {
            this.configurationSetName = x.configurationSetName
            this.trackingOptions = x.trackingOptions
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ses.model.UpdateConfigurationSetTrackingOptionsRequest = UpdateConfigurationSetTrackingOptionsRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.ses.model.TrackingOptions] inside the given [block]
         */
        public fun trackingOptions(block: aws.sdk.kotlin.services.ses.model.TrackingOptions.Builder.() -> kotlin.Unit) {
            this.trackingOptions = aws.sdk.kotlin.services.ses.model.TrackingOptions.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
