// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ses.model



/**
 * Represents a request to update the event destination of a configuration set. Configuration sets enable you to publish email sending events. For information about using configuration sets, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/monitor-sending-activity.html).
 */
public class UpdateConfigurationSetEventDestinationRequest private constructor(builder: Builder) {
    /**
     * The name of the configuration set that contains the event destination.
     */
    public val configurationSetName: kotlin.String? = builder.configurationSetName
    /**
     * The event destination object.
     */
    public val eventDestination: aws.sdk.kotlin.services.ses.model.EventDestination? = builder.eventDestination

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ses.model.UpdateConfigurationSetEventDestinationRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateConfigurationSetEventDestinationRequest(")
        append("configurationSetName=$configurationSetName,")
        append("eventDestination=$eventDestination")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = configurationSetName?.hashCode() ?: 0
        result = 31 * result + (eventDestination?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateConfigurationSetEventDestinationRequest

        if (configurationSetName != other.configurationSetName) return false
        if (eventDestination != other.eventDestination) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ses.model.UpdateConfigurationSetEventDestinationRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the configuration set that contains the event destination.
         */
        public var configurationSetName: kotlin.String? = null
        /**
         * The event destination object.
         */
        public var eventDestination: aws.sdk.kotlin.services.ses.model.EventDestination? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ses.model.UpdateConfigurationSetEventDestinationRequest) : this() {
            this.configurationSetName = x.configurationSetName
            this.eventDestination = x.eventDestination
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ses.model.UpdateConfigurationSetEventDestinationRequest = UpdateConfigurationSetEventDestinationRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.ses.model.EventDestination] inside the given [block]
         */
        public fun eventDestination(block: aws.sdk.kotlin.services.ses.model.EventDestination.Builder.() -> kotlin.Unit) {
            this.eventDestination = aws.sdk.kotlin.services.ses.model.EventDestination.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
