// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ses.model



/**
 * A domain that is used to redirect email recipients to an Amazon SES-operated domain. This domain captures open and click events generated by Amazon SES emails.
 *
 * For more information, see [Configuring Custom Domains to Handle Open and Click Tracking](https://docs.aws.amazon.com/ses/latest/dg/configure-custom-open-click-domains.html) in the *Amazon SES Developer Guide*.
 */
public class TrackingOptions private constructor(builder: Builder) {
    /**
     * The custom subdomain that is used to redirect email recipients to the Amazon SES event tracking domain.
     */
    public val customRedirectDomain: kotlin.String? = builder.customRedirectDomain

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ses.model.TrackingOptions = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TrackingOptions(")
        append("customRedirectDomain=$customRedirectDomain")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = customRedirectDomain?.hashCode() ?: 0
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TrackingOptions

        if (customRedirectDomain != other.customRedirectDomain) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ses.model.TrackingOptions = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The custom subdomain that is used to redirect email recipients to the Amazon SES event tracking domain.
         */
        public var customRedirectDomain: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ses.model.TrackingOptions) : this() {
            this.customRedirectDomain = x.customRedirectDomain
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ses.model.TrackingOptions = TrackingOptions(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
