// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ses.model



/**
 * Represents a request to enable or disable the Amazon SES custom MAIL FROM domain setup for a verified identity. For information about using a custom MAIL FROM domain, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/mail-from.html).
 */
public class SetIdentityMailFromDomainRequest private constructor(builder: Builder) {
    /**
     * The action for Amazon SES to take if it cannot successfully read the required MX record when you send an email. If you choose `UseDefaultValue`, Amazon SES uses amazonses.com (or a subdomain of that) as the MAIL FROM domain. If you choose `RejectMessage`, Amazon SES returns a `MailFromDomainNotVerified` error and not send the email.
     *
     * The action specified in `BehaviorOnMXFailure` is taken when the custom MAIL FROM domain setup is in the `Pending`, `Failed`, and `TemporaryFailure` states.
     */
    public val behaviorOnMxFailure: aws.sdk.kotlin.services.ses.model.BehaviorOnMxFailure? = builder.behaviorOnMxFailure
    /**
     * The verified identity.
     */
    public val identity: kotlin.String? = builder.identity
    /**
     * The custom MAIL FROM domain for the verified identity to use. The MAIL FROM domain must 1) be a subdomain of the verified identity, 2) not be used in a "From" address if the MAIL FROM domain is the destination of email feedback forwarding (for more information, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/mail-from.html)), and 3) not be used to receive emails. A value of `null` disables the custom MAIL FROM setting for the identity.
     */
    public val mailFromDomain: kotlin.String? = builder.mailFromDomain

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ses.model.SetIdentityMailFromDomainRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SetIdentityMailFromDomainRequest(")
        append("behaviorOnMxFailure=$behaviorOnMxFailure,")
        append("identity=$identity,")
        append("mailFromDomain=$mailFromDomain")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = behaviorOnMxFailure?.hashCode() ?: 0
        result = 31 * result + (identity?.hashCode() ?: 0)
        result = 31 * result + (mailFromDomain?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SetIdentityMailFromDomainRequest

        if (behaviorOnMxFailure != other.behaviorOnMxFailure) return false
        if (identity != other.identity) return false
        if (mailFromDomain != other.mailFromDomain) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ses.model.SetIdentityMailFromDomainRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The action for Amazon SES to take if it cannot successfully read the required MX record when you send an email. If you choose `UseDefaultValue`, Amazon SES uses amazonses.com (or a subdomain of that) as the MAIL FROM domain. If you choose `RejectMessage`, Amazon SES returns a `MailFromDomainNotVerified` error and not send the email.
         *
         * The action specified in `BehaviorOnMXFailure` is taken when the custom MAIL FROM domain setup is in the `Pending`, `Failed`, and `TemporaryFailure` states.
         */
        public var behaviorOnMxFailure: aws.sdk.kotlin.services.ses.model.BehaviorOnMxFailure? = null
        /**
         * The verified identity.
         */
        public var identity: kotlin.String? = null
        /**
         * The custom MAIL FROM domain for the verified identity to use. The MAIL FROM domain must 1) be a subdomain of the verified identity, 2) not be used in a "From" address if the MAIL FROM domain is the destination of email feedback forwarding (for more information, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/mail-from.html)), and 3) not be used to receive emails. A value of `null` disables the custom MAIL FROM setting for the identity.
         */
        public var mailFromDomain: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ses.model.SetIdentityMailFromDomainRequest) : this() {
            this.behaviorOnMxFailure = x.behaviorOnMxFailure
            this.identity = x.identity
            this.mailFromDomain = x.mailFromDomain
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ses.model.SetIdentityMailFromDomainRequest = SetIdentityMailFromDomainRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
