// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ses.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains information about the reputation settings for a configuration set.
 */
public class ReputationOptions private constructor(builder: Builder) {
    /**
     * The date and time at which the reputation metrics for the configuration set were last reset. Resetting these metrics is known as a *fresh start*.
     *
     * When you disable email sending for a configuration set using UpdateConfigurationSetSendingEnabled and later re-enable it, the reputation metrics for the configuration set (but not for the entire Amazon SES account) are reset.
     *
     * If email sending for the configuration set has never been disabled and later re-enabled, the value of this attribute is `null`.
     */
    public val lastFreshStart: aws.smithy.kotlin.runtime.time.Instant? = builder.lastFreshStart
    /**
     * Describes whether or not Amazon SES publishes reputation metrics for the configuration set, such as bounce and complaint rates, to Amazon CloudWatch.
     *
     * If the value is `true`, reputation metrics are published. If the value is `false`, reputation metrics are not published. The default value is `false`.
     */
    public val reputationMetricsEnabled: kotlin.Boolean = builder.reputationMetricsEnabled
    /**
     * Describes whether email sending is enabled or disabled for the configuration set. If the value is `true`, then Amazon SES sends emails that use the configuration set. If the value is `false`, Amazon SES does not send emails that use the configuration set. The default value is `true`. You can change this setting using UpdateConfigurationSetSendingEnabled.
     */
    public val sendingEnabled: kotlin.Boolean = builder.sendingEnabled

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ses.model.ReputationOptions = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ReputationOptions(")
        append("lastFreshStart=$lastFreshStart,")
        append("reputationMetricsEnabled=$reputationMetricsEnabled,")
        append("sendingEnabled=$sendingEnabled")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = lastFreshStart?.hashCode() ?: 0
        result = 31 * result + (reputationMetricsEnabled.hashCode())
        result = 31 * result + (sendingEnabled.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ReputationOptions

        if (lastFreshStart != other.lastFreshStart) return false
        if (reputationMetricsEnabled != other.reputationMetricsEnabled) return false
        if (sendingEnabled != other.sendingEnabled) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ses.model.ReputationOptions = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The date and time at which the reputation metrics for the configuration set were last reset. Resetting these metrics is known as a *fresh start*.
         *
         * When you disable email sending for a configuration set using UpdateConfigurationSetSendingEnabled and later re-enable it, the reputation metrics for the configuration set (but not for the entire Amazon SES account) are reset.
         *
         * If email sending for the configuration set has never been disabled and later re-enabled, the value of this attribute is `null`.
         */
        public var lastFreshStart: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Describes whether or not Amazon SES publishes reputation metrics for the configuration set, such as bounce and complaint rates, to Amazon CloudWatch.
         *
         * If the value is `true`, reputation metrics are published. If the value is `false`, reputation metrics are not published. The default value is `false`.
         */
        public var reputationMetricsEnabled: kotlin.Boolean = false
        /**
         * Describes whether email sending is enabled or disabled for the configuration set. If the value is `true`, then Amazon SES sends emails that use the configuration set. If the value is `false`, Amazon SES does not send emails that use the configuration set. The default value is `true`. You can change this setting using UpdateConfigurationSetSendingEnabled.
         */
        public var sendingEnabled: kotlin.Boolean = false

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ses.model.ReputationOptions) : this() {
            this.lastFreshStart = x.lastFreshStart
            this.reputationMetricsEnabled = x.reputationMetricsEnabled
            this.sendingEnabled = x.sendingEnabled
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ses.model.ReputationOptions = ReputationOptions(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
