// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ses.model



/**
 * Represents the raw data of the message.
 */
public class RawMessage private constructor(builder: Builder) {
    /**
     * The raw data of the message. This data needs to base64-encoded if you are accessing Amazon SES directly through the HTTPS interface. If you are accessing Amazon SES using an Amazon Web Services SDK, the SDK takes care of the base 64-encoding for you. In all cases, the client must ensure that the message format complies with Internet email standards regarding email header fields, MIME types, and MIME encoding.
     *
     * The To:, CC:, and BCC: headers in the raw message can contain a group list.
     *
     * If you are using `SendRawEmail` with sending authorization, you can include X-headers in the raw message to specify the "Source," "From," and "Return-Path" addresses. For more information, see the documentation for `SendRawEmail`.
     *
     * Do not include these X-headers in the DKIM signature, because they are removed by Amazon SES before sending the email.
     *
     * For more information, go to the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/send-email-raw.html).
     */
    public val data: kotlin.ByteArray = requireNotNull(builder.data) { "A non-null value must be provided for data" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ses.model.RawMessage = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RawMessage(")
        append("data=$data")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = data.contentHashCode()
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RawMessage

        if (data != null) {
            if (other.data == null) return false
            if (!data.contentEquals(other.data)) return false
        } else if (other.data != null) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ses.model.RawMessage = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The raw data of the message. This data needs to base64-encoded if you are accessing Amazon SES directly through the HTTPS interface. If you are accessing Amazon SES using an Amazon Web Services SDK, the SDK takes care of the base 64-encoding for you. In all cases, the client must ensure that the message format complies with Internet email standards regarding email header fields, MIME types, and MIME encoding.
         *
         * The To:, CC:, and BCC: headers in the raw message can contain a group list.
         *
         * If you are using `SendRawEmail` with sending authorization, you can include X-headers in the raw message to specify the "Source," "From," and "Return-Path" addresses. For more information, see the documentation for `SendRawEmail`.
         *
         * Do not include these X-headers in the DKIM signature, because they are removed by Amazon SES before sending the email.
         *
         * For more information, go to the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/send-email-raw.html).
         */
        public var data: kotlin.ByteArray? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ses.model.RawMessage) : this() {
            this.data = x.data
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ses.model.RawMessage = RawMessage(this)

        internal fun correctErrors(): Builder {
            if (data == null) data = ByteArray(0)
            return this
        }
    }
}
