// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ses.model



/**
 * Represents a request to return a list of all identities (email addresses and domains) that you have attempted to verify under your Amazon Web Services account, regardless of verification status.
 */
public class ListIdentitiesRequest private constructor(builder: Builder) {
    /**
     * The type of the identities to list. Possible values are "EmailAddress" and "Domain". If this parameter is omitted, then all identities are listed.
     */
    public val identityType: aws.sdk.kotlin.services.ses.model.IdentityType? = builder.identityType
    /**
     * The maximum number of identities per page. Possible values are 1-1000 inclusive.
     */
    public val maxItems: kotlin.Int? = builder.maxItems
    /**
     * The token to use for pagination.
     */
    public val nextToken: kotlin.String? = builder.nextToken

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ses.model.ListIdentitiesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListIdentitiesRequest(")
        append("identityType=$identityType,")
        append("maxItems=$maxItems,")
        append("nextToken=$nextToken")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = identityType?.hashCode() ?: 0
        result = 31 * result + (maxItems ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListIdentitiesRequest

        if (identityType != other.identityType) return false
        if (maxItems != other.maxItems) return false
        if (nextToken != other.nextToken) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ses.model.ListIdentitiesRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The type of the identities to list. Possible values are "EmailAddress" and "Domain". If this parameter is omitted, then all identities are listed.
         */
        public var identityType: aws.sdk.kotlin.services.ses.model.IdentityType? = null
        /**
         * The maximum number of identities per page. Possible values are 1-1000 inclusive.
         */
        public var maxItems: kotlin.Int? = null
        /**
         * The token to use for pagination.
         */
        public var nextToken: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ses.model.ListIdentitiesRequest) : this() {
            this.identityType = x.identityType
            this.maxItems = x.maxItems
            this.nextToken = x.nextToken
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ses.model.ListIdentitiesRequest = ListIdentitiesRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
