// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ses.model



/**
 * Represents a request to return the requested sending authorization policies for an identity. Sending authorization is an Amazon SES feature that enables you to authorize other senders to use your identities. For information, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/sending-authorization.html).
 */
public class GetIdentityPoliciesRequest private constructor(builder: Builder) {
    /**
     * The identity for which the policies are retrieved. You can specify an identity by using its name or by using its Amazon Resource Name (ARN). Examples: `user@example.com`, `example.com`, `arn:aws:ses:us-east-1:123456789012:identity/example.com`.
     *
     * To successfully call this operation, you must own the identity.
     */
    public val identity: kotlin.String? = builder.identity
    /**
     * A list of the names of policies to be retrieved. You can retrieve a maximum of 20 policies at a time. If you do not know the names of the policies that are attached to the identity, you can use `ListIdentityPolicies`.
     */
    public val policyNames: List<String>? = builder.policyNames

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ses.model.GetIdentityPoliciesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetIdentityPoliciesRequest(")
        append("identity=$identity,")
        append("policyNames=$policyNames")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = identity?.hashCode() ?: 0
        result = 31 * result + (policyNames?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetIdentityPoliciesRequest

        if (identity != other.identity) return false
        if (policyNames != other.policyNames) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ses.model.GetIdentityPoliciesRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The identity for which the policies are retrieved. You can specify an identity by using its name or by using its Amazon Resource Name (ARN). Examples: `user@example.com`, `example.com`, `arn:aws:ses:us-east-1:123456789012:identity/example.com`.
         *
         * To successfully call this operation, you must own the identity.
         */
        public var identity: kotlin.String? = null
        /**
         * A list of the names of policies to be retrieved. You can retrieve a maximum of 20 policies at a time. If you do not know the names of the policies that are attached to the identity, you can use `ListIdentityPolicies`.
         */
        public var policyNames: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ses.model.GetIdentityPoliciesRequest) : this() {
            this.identity = x.identity
            this.policyNames = x.policyNames
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ses.model.GetIdentityPoliciesRequest = GetIdentityPoliciesRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
