// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ses.model



/**
 * Represents the details of a configuration set. Configuration sets enable you to publish email sending events. For information about using configuration sets, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/monitor-sending-activity.html).
 */
public class DescribeConfigurationSetResponse private constructor(builder: Builder) {
    /**
     * The configuration set object associated with the specified configuration set.
     */
    public val configurationSet: aws.sdk.kotlin.services.ses.model.ConfigurationSet? = builder.configurationSet
    /**
     * Specifies whether messages that use the configuration set are required to use Transport Layer Security (TLS).
     */
    public val deliveryOptions: aws.sdk.kotlin.services.ses.model.DeliveryOptions? = builder.deliveryOptions
    /**
     * A list of event destinations associated with the configuration set.
     */
    public val eventDestinations: List<EventDestination>? = builder.eventDestinations
    /**
     * An object that represents the reputation settings for the configuration set.
     */
    public val reputationOptions: aws.sdk.kotlin.services.ses.model.ReputationOptions? = builder.reputationOptions
    /**
     * The name of the custom open and click tracking domain associated with the configuration set.
     */
    public val trackingOptions: aws.sdk.kotlin.services.ses.model.TrackingOptions? = builder.trackingOptions

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ses.model.DescribeConfigurationSetResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeConfigurationSetResponse(")
        append("configurationSet=$configurationSet,")
        append("deliveryOptions=$deliveryOptions,")
        append("eventDestinations=$eventDestinations,")
        append("reputationOptions=$reputationOptions,")
        append("trackingOptions=$trackingOptions")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = configurationSet?.hashCode() ?: 0
        result = 31 * result + (deliveryOptions?.hashCode() ?: 0)
        result = 31 * result + (eventDestinations?.hashCode() ?: 0)
        result = 31 * result + (reputationOptions?.hashCode() ?: 0)
        result = 31 * result + (trackingOptions?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeConfigurationSetResponse

        if (configurationSet != other.configurationSet) return false
        if (deliveryOptions != other.deliveryOptions) return false
        if (eventDestinations != other.eventDestinations) return false
        if (reputationOptions != other.reputationOptions) return false
        if (trackingOptions != other.trackingOptions) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ses.model.DescribeConfigurationSetResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The configuration set object associated with the specified configuration set.
         */
        public var configurationSet: aws.sdk.kotlin.services.ses.model.ConfigurationSet? = null
        /**
         * Specifies whether messages that use the configuration set are required to use Transport Layer Security (TLS).
         */
        public var deliveryOptions: aws.sdk.kotlin.services.ses.model.DeliveryOptions? = null
        /**
         * A list of event destinations associated with the configuration set.
         */
        public var eventDestinations: List<EventDestination>? = null
        /**
         * An object that represents the reputation settings for the configuration set.
         */
        public var reputationOptions: aws.sdk.kotlin.services.ses.model.ReputationOptions? = null
        /**
         * The name of the custom open and click tracking domain associated with the configuration set.
         */
        public var trackingOptions: aws.sdk.kotlin.services.ses.model.TrackingOptions? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ses.model.DescribeConfigurationSetResponse) : this() {
            this.configurationSet = x.configurationSet
            this.deliveryOptions = x.deliveryOptions
            this.eventDestinations = x.eventDestinations
            this.reputationOptions = x.reputationOptions
            this.trackingOptions = x.trackingOptions
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ses.model.DescribeConfigurationSetResponse = DescribeConfigurationSetResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.ses.model.ConfigurationSet] inside the given [block]
         */
        public fun configurationSet(block: aws.sdk.kotlin.services.ses.model.ConfigurationSet.Builder.() -> kotlin.Unit) {
            this.configurationSet = aws.sdk.kotlin.services.ses.model.ConfigurationSet.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ses.model.DeliveryOptions] inside the given [block]
         */
        public fun deliveryOptions(block: aws.sdk.kotlin.services.ses.model.DeliveryOptions.Builder.() -> kotlin.Unit) {
            this.deliveryOptions = aws.sdk.kotlin.services.ses.model.DeliveryOptions.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ses.model.ReputationOptions] inside the given [block]
         */
        public fun reputationOptions(block: aws.sdk.kotlin.services.ses.model.ReputationOptions.Builder.() -> kotlin.Unit) {
            this.reputationOptions = aws.sdk.kotlin.services.ses.model.ReputationOptions.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ses.model.TrackingOptions] inside the given [block]
         */
        public fun trackingOptions(block: aws.sdk.kotlin.services.ses.model.TrackingOptions.Builder.() -> kotlin.Unit) {
            this.trackingOptions = aws.sdk.kotlin.services.ses.model.TrackingOptions.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
