// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ses.model



/**
 * Represents a request to create a configuration set event destination. A configuration set event destination, which can be either Amazon CloudWatch or Amazon Kinesis Firehose, describes an Amazon Web Services service in which Amazon SES publishes the email sending events associated with a configuration set. For information about using configuration sets, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/dg/monitor-sending-activity.html).
 */
public class CreateConfigurationSetEventDestinationRequest private constructor(builder: Builder) {
    /**
     * The name of the configuration set that the event destination should be associated with.
     */
    public val configurationSetName: kotlin.String? = builder.configurationSetName
    /**
     * An object that describes the Amazon Web Services service that email sending event where information is published.
     */
    public val eventDestination: aws.sdk.kotlin.services.ses.model.EventDestination? = builder.eventDestination

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ses.model.CreateConfigurationSetEventDestinationRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateConfigurationSetEventDestinationRequest(")
        append("configurationSetName=$configurationSetName,")
        append("eventDestination=$eventDestination")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = configurationSetName?.hashCode() ?: 0
        result = 31 * result + (eventDestination?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateConfigurationSetEventDestinationRequest

        if (configurationSetName != other.configurationSetName) return false
        if (eventDestination != other.eventDestination) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ses.model.CreateConfigurationSetEventDestinationRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the configuration set that the event destination should be associated with.
         */
        public var configurationSetName: kotlin.String? = null
        /**
         * An object that describes the Amazon Web Services service that email sending event where information is published.
         */
        public var eventDestination: aws.sdk.kotlin.services.ses.model.EventDestination? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ses.model.CreateConfigurationSetEventDestinationRequest) : this() {
            this.configurationSetName = x.configurationSetName
            this.eventDestination = x.eventDestination
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ses.model.CreateConfigurationSetEventDestinationRequest = CreateConfigurationSetEventDestinationRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.ses.model.EventDestination] inside the given [block]
         */
        public fun eventDestination(block: aws.sdk.kotlin.services.ses.model.EventDestination.Builder.() -> kotlin.Unit) {
            this.eventDestination = aws.sdk.kotlin.services.ses.model.EventDestination.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
