// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ses.model



/**
 * Represents textual data, plus an optional character set specification.
 *
 * By default, the text must be 7-bit ASCII, due to the constraints of the SMTP protocol. If the text must contain any other characters, then you must also specify a character set. Examples include UTF-8, ISO-8859-1, and Shift_JIS.
 */
public class Content private constructor(builder: Builder) {
    /**
     * The character set of the content.
     */
    public val charset: kotlin.String? = builder.charset
    /**
     * The textual data of the content.
     */
    public val data: kotlin.String = requireNotNull(builder.data) { "A non-null value must be provided for data" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ses.model.Content = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Content(")
        append("charset=$charset,")
        append("data=$data")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = charset?.hashCode() ?: 0
        result = 31 * result + (data.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Content

        if (charset != other.charset) return false
        if (data != other.data) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ses.model.Content = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The character set of the content.
         */
        public var charset: kotlin.String? = null
        /**
         * The textual data of the content.
         */
        public var data: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ses.model.Content) : this() {
            this.charset = x.charset
            this.data = x.data
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ses.model.Content = Content(this)

        internal fun correctErrors(): Builder {
            if (data == null) data = ""
            return this
        }
    }
}
